/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;

final class BytesBinaryDVAtomicFieldData
implements AtomicFieldData<ScriptDocValues> {
    private final BinaryDocValues values;

    BytesBinaryDVAtomicFieldData(BinaryDocValues values) {
        this.values = values;
    }

    public long ramBytesUsed() {
        return -1L;
    }

    @Override
    public BytesValues getBytesValues() {
        return new BytesValues(true){
            BytesRef bytes;
            final BytesRef scratch;
            final ByteArrayDataInput in;
            {
                this.scratch = new BytesRef();
                this.in = new ByteArrayDataInput();
            }

            @Override
            public int setDocument(int docId) {
                this.bytes = BytesBinaryDVAtomicFieldData.this.values.get(docId);
                this.in.reset(this.bytes.bytes, this.bytes.offset, this.bytes.length);
                if (this.bytes.length == 0) {
                    return 0;
                }
                return this.in.readVInt();
            }

            @Override
            public BytesRef nextValue() {
                int length = this.in.readVInt();
                this.scratch.grow(length);
                this.in.readBytes(this.scratch.bytes, 0, length);
                this.scratch.length = length;
                this.scratch.offset = 0;
                return this.scratch;
            }
        };
    }

    @Override
    public ScriptDocValues getScriptValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }
}

