/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore.lin;

import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.index.query.functionscore.DecayFunction;
import org.elasticsearch.index.query.functionscore.DecayFunctionParser;

public class LinearDecayFunctionParser
extends DecayFunctionParser {
    public static final String[] NAMES = new String[]{"linear"};
    static final DecayFunction decayFunction = new LinearDecayScoreFunction();

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public DecayFunction getDecayFunction() {
        return decayFunction;
    }

    static final class LinearDecayScoreFunction
    implements DecayFunction {
        LinearDecayScoreFunction() {
        }

        @Override
        public double evaluate(double value, double scale) {
            return Math.max(0.0, (scale - value) / scale);
        }

        @Override
        public Explanation explainFunction(String valueExpl, double value, double scale) {
            ComplexExplanation ce = new ComplexExplanation();
            ce.setValue((float)this.evaluate(value, scale));
            ce.setDescription("max(0.0, ((" + scale + " - " + valueExpl + ")/" + scale + ")");
            return ce;
        }

        @Override
        public double processScale(double scale, double decay) {
            return scale / (1.0 - decay);
        }
    }
}

