@echo off
REM
REM Batch script to start the XL Test Server
REM

setlocal ENABLEDELAYEDEXPANSION

REM Get Java executable
if "%JAVA_HOME%"=="" (
  set JAVACMD=java
) else (
  set JAVACMD="%JAVA_HOME%\bin\java"
)

REM Get JVM options
if "%XLTEST_SERVER_OPTS%"=="" (
  set XLTEST_SERVER_OPTS=-Xmx1024m -XX:MaxPermSize=128m
)

REM Get logging-related options
if "%XLTEST_SERVER_LOG_OPTS%"=="" (
  set XLTEST_SERVER_LOG_OPTS=-Dlogback.configurationFile=conf\logback.xml -Dderby.stream.error.file=log\derby.log
)

REM Get XL Test server home dir
if "%XLTEST_SERVER_HOME%"=="" (
  cd /d "%~dp0"
  cd ..
  set XLTEST_SERVER_HOME=!CD!
)

cd /d "%XLTEST_SERVER_HOME%"

REM Build XL Test server classpath
set XLTEST_SERVER_CLASSPATH=conf;ext
for %%i in (hotfix\*.jar) do set XLTEST_SERVER_CLASSPATH=!XLTEST_SERVER_CLASSPATH!;%%i
for %%i in (lib\*.jar) do set XLTEST_SERVER_CLASSPATH=!XLTEST_SERVER_CLASSPATH!;%%i
for %%i in (plugins\*.jar) do set XLTEST_SERVER_CLASSPATH=!XLTEST_SERVER_CLASSPATH!;%%i
for /d %%i in (plugins\*) do set XLTEST_SERVER_CLASSPATH=!XLTEST_SERVER_CLASSPATH!;%%i

REM Run XL Test server
%JAVACMD% %XLTEST_SERVER_OPTS% %XLTEST_SERVER_LOG_OPTS% -cp "%XLTEST_SERVER_CLASSPATH%" com.xebialabs.xltest.Main %*

:end
endlocal
