package com.xebialabs.xltest.serialize;

import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONWriter;
import org.springframework.stereotype.Component;

import com.xebialabs.xltest.XLTestManifest;

@Component
@Provider
@Produces({MediaType.APPLICATION_JSON})
public class ManifestWriter extends BasicMessageBodyWriter<XLTestManifest> {

    protected void writeJson(final XLTestManifest manifest, final JSONWriter writer) throws JSONException {
        writer.object();
        writer.key("name").value(manifest.getName());
        writer.key("vendor").value(manifest.getVendor());
        writer.key("version").value(manifest.getVersion());
        writer.key("build").value(manifest.getBuild());
        writer.endObject();
    }
}
