/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.ArrayListMultimap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.support.BucketPriorityQueue;

public abstract class InternalTerms
extends InternalAggregation
implements Terms,
ToXContent,
Streamable {
    protected InternalOrder order;
    protected int requiredSize;
    protected long minDocCount;
    protected Collection<Bucket> buckets;
    protected Map<String, Bucket> bucketMap;

    protected InternalTerms() {
    }

    protected InternalTerms(String name, InternalOrder order, int requiredSize, long minDocCount, Collection<Bucket> buckets) {
        super(name);
        this.order = order;
        this.requiredSize = requiredSize;
        this.minDocCount = minDocCount;
        this.buckets = buckets;
    }

    @Override
    public Collection<Terms.Bucket> getBuckets() {
        Collection<Terms.Bucket> o = this.buckets;
        return o;
    }

    @Override
    public Terms.Bucket getBucketByKey(String term) {
        if (this.bucketMap == null) {
            this.bucketMap = Maps.newHashMapWithExpectedSize(this.buckets.size());
            for (Bucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKey(), bucket);
            }
        }
        return this.bucketMap.get(term);
    }

    @Override
    public InternalAggregation reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        ArrayListMultimap<Object, Bucket> buckets = ArrayListMultimap.create();
        for (InternalAggregation aggregation : aggregations) {
            InternalTerms terms = (InternalTerms)aggregation;
            for (Bucket bucket : terms.buckets) {
                buckets.put(bucket.getKeyAsObject(), bucket);
            }
        }
        int size = Math.min(this.requiredSize, buckets.size());
        BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.order.comparator(null));
        for (Collection l : buckets.asMap().values()) {
            List sameTermBuckets = (List)l;
            Bucket b = ((Bucket)sameTermBuckets.get(0)).reduce(sameTermBuckets, reduceContext.bigArrays());
            if (b.docCount < this.minDocCount) continue;
            ordered.insertWithOverflow(b);
        }
        Bucket[] list = new Bucket[ordered.size()];
        for (int i = ordered.size() - 1; i >= 0; --i) {
            list[i] = (Bucket)ordered.pop();
        }
        return this.newAggregation(this.name, Arrays.asList(list));
    }

    protected abstract InternalTerms newAggregation(String var1, List<Bucket> var2);

    public static abstract class Bucket
    extends Terms.Bucket {
        long bucketOrd;
        protected long docCount;
        protected InternalAggregations aggregations;

        protected Bucket(long docCount, InternalAggregations aggregations) {
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        abstract Object getKeyAsObject();

        abstract Bucket newBucket(long var1, InternalAggregations var3);

        public Bucket reduce(List<? extends Bucket> buckets, BigArrays bigArrays) {
            long docCount = 0L;
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
            for (Bucket bucket : buckets) {
                docCount += bucket.docCount;
                aggregationsList.add(bucket.aggregations);
            }
            InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, bigArrays);
            return this.newBucket(docCount, aggs);
        }
    }
}

