/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.metrics.ValuesSourceMetricsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.InternalPercentiles;

public class PercentilesBuilder
extends ValuesSourceMetricsAggregationBuilder<PercentilesBuilder> {
    private double[] percentiles;
    private Double compression;

    public PercentilesBuilder(String name) {
        super(name, InternalPercentiles.TYPE.name());
    }

    public PercentilesBuilder percentiles(double ... percentiles) {
        for (int i = 0; i < percentiles.length; ++i) {
            if (!(percentiles[i] < 0.0) && !(percentiles[i] > 100.0)) continue;
            throw new IllegalArgumentException("the percents in the percentiles aggregation [" + this.name + "] must be in the [0, 100] range");
        }
        this.percentiles = percentiles;
        return this;
    }

    public PercentilesBuilder compression(double compression) {
        this.compression = compression;
        return this;
    }

    @Override
    protected void internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.internalXContent(builder, params);
        if (this.percentiles != null) {
            builder.field("percents", this.percentiles);
        }
        if (this.compression != null) {
            builder.field("compression", this.compression);
        }
    }
}

