/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager;
import org.apache.jackrabbit.core.persistence.check.ConsistencyCheckListener;
import org.apache.jackrabbit.core.persistence.check.ConsistencyReport;
import org.apache.jackrabbit.core.persistence.check.ConsistencyReportImpl;
import org.apache.jackrabbit.core.persistence.check.ReportItem;
import org.apache.jackrabbit.core.persistence.check.ReportItemImpl;
import org.apache.jackrabbit.core.persistence.util.NodeInfo;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyCheckerImpl {
    private static Logger log = LoggerFactory.getLogger(ConsistencyCheckerImpl.class);
    private final AbstractBundlePersistenceManager pm;
    private final ConsistencyCheckListener listener;
    private static final NameFactory NF = NameFactoryImpl.getInstance();
    private static final int NODESATONCE = Integer.getInteger("org.apache.jackrabbit.checker.nodesatonce", 8192);
    private static final boolean CHECKAFTERLOADING = Boolean.getBoolean("org.apache.jackrabbit.checker.checkafterloading");

    public ConsistencyCheckerImpl(AbstractBundlePersistenceManager pm, ConsistencyCheckListener listener) {
        this.pm = pm;
        this.listener = listener;
    }

    public ConsistencyReport check(String[] uuids, boolean recursive, boolean fix, String lostNFoundId) throws RepositoryException {
        HashSet<ReportItem> reports = new HashSet<ReportItem>();
        long tstart = System.currentTimeMillis();
        int total = this.internalCheckConsistency(uuids, recursive, fix, reports, lostNFoundId);
        long elapsed = System.currentTimeMillis() - tstart;
        return new ConsistencyReportImpl(total, elapsed, reports);
    }

    /*
     * Unable to fully structure code
     */
    private int internalCheckConsistency(String[] uuids, boolean recursive, boolean fix, Set<ReportItem> reports, String lostNFoundId) throws RepositoryException {
        block25: {
            count = 0;
            lostNFound = null;
            if (fix) {
                if (lostNFoundId != null) {
                    try {
                        tmpid = new NodeId(lostNFoundId);
                        lfBundle = this.pm.loadBundle(tmpid);
                        if (lfBundle == null) {
                            this.error(lostNFoundId, "Specified 'lost+found' node does not exist");
                            break block25;
                        }
                        if (!NameConstants.NT_UNSTRUCTURED.equals(lfBundle.getNodeTypeName())) {
                            this.error(lostNFoundId, "Specified 'lost+found' node is not of type nt:unstructured");
                            break block25;
                        }
                        lostNFound = lfBundle.getId();
                    }
                    catch (Exception ex) {
                        this.error(lostNFoundId, "finding 'lost+found' folder", ex);
                    }
                } else {
                    ConsistencyCheckerImpl.log.info("No 'lost+found' node specified: orphans cannot be fixed");
                }
            }
        }
        if (uuids == null) {
            try {
                allInfos = batch = this.pm.getAllNodeInfos(null, ConsistencyCheckerImpl.NODESATONCE);
                lastId = null;
                while (!batch.isEmpty()) {
                    for (Map.Entry<NodeId, NodeInfo> entry : batch.entrySet()) {
                        lastId = id = entry.getKey();
                        if (++count % 1000 == 0) {
                            ConsistencyCheckerImpl.log.info(this.pm + ": loaded " + count + " infos...");
                        }
                        if (ConsistencyCheckerImpl.CHECKAFTERLOADING) continue;
                        nodeInfo = entry.getValue();
                        this.checkBundleConsistency(id, nodeInfo, fix, lostNFound, reports, batch);
                    }
                    batch = this.pm.getAllNodeInfos(lastId, ConsistencyCheckerImpl.NODESATONCE);
                    if (!ConsistencyCheckerImpl.CHECKAFTERLOADING) continue;
                    allInfos.putAll(batch);
                }
                if (!ConsistencyCheckerImpl.CHECKAFTERLOADING) ** GOTO lbl79
                if (this.pm.exists(lastId)) {
                    for (Map.Entry<NodeId, NodeInfo> entry : allInfos.entrySet()) {
                        this.checkBundleConsistency(entry.getKey(), entry.getValue(), fix, lostNFound, reports, allInfos);
                    }
                }
                ConsistencyCheckerImpl.log.info("Failed to read all nodes, starting over");
                this.internalCheckConsistency(uuids, recursive, fix, reports, lostNFoundId);
            }
            catch (ItemStateException ex) {
                throw new RepositoryException("getting nodeIds", (Throwable)ex);
            }
        } else {
            idList = new ArrayList<NodeId>(uuids.length);
            for (i = 0; i < uuids.length; ++i) {
                try {
                    idList.add(new NodeId(uuids[i]));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.error(uuids[i], "Invalid id for consistency check, skipping: '" + uuids[i] + "': " + e);
                }
            }
            for (i = 0; i < idList.size(); ++i) {
                id = (NodeId)idList.get(i);
                try {
                    bundle = this.pm.loadBundle(id);
                    if (bundle == null) {
                        if (this.isVirtualNode(id)) continue;
                        this.error(id.toString(), "No bundle found for id '" + id + "'");
                        continue;
                    }
                    this.checkBundleConsistency(id, new NodeInfo(bundle), fix, lostNFound, reports, Collections.<NodeId, NodeInfo>emptyMap());
                    if (recursive) {
                        for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
                            idList.add(entry.getId());
                        }
                    }
                    if (++count % 1000 != 0 || this.listener != null) continue;
                    ConsistencyCheckerImpl.log.info(this.pm + ": checked " + count + "/" + idList.size() + " bundles...");
                    continue;
                }
                catch (ItemStateException e) {
                    // empty catch block
                }
            }
        }
lbl79:
        // 4 sources

        ConsistencyCheckerImpl.log.info(this.pm + ": checked " + count + " bundles.");
        NodeInfo.clearPool();
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkBundleConsistency(NodeId id, NodeInfo nodeInfo, boolean fix, NodeId lostNFoundId, Set<ReportItem> reports, Map<NodeId, NodeInfo> infos) {
        if (this.isVirtualNode(id)) {
            return;
        }
        if (this.listener != null) {
            this.listener.startCheck(id.toString());
        }
        ArrayList<NodePropBundle.ChildNodeEntry> missingChildren = new ArrayList<NodePropBundle.ChildNodeEntry>();
        ArrayList<NodePropBundle.ChildNodeEntry> disconnectedChildren = new ArrayList<NodePropBundle.ChildNodeEntry>();
        NodePropBundle bundle = null;
        for (NodeId childNodeId : nodeInfo.getChildren()) {
            if (childNodeId.toString().endsWith("babecafebabe")) continue;
            try {
                NodeId cp;
                NodePropBundle childBundle = null;
                NodeInfo childNodeInfo = infos.get(childNodeId);
                if (childNodeInfo == null) {
                    childBundle = this.pm.loadBundle(childNodeId);
                    if (childBundle == null) {
                        if (bundle == null) {
                            bundle = this.pm.loadBundle(id);
                        }
                        if (bundle == null) return;
                        NodePropBundle.ChildNodeEntry childNodeEntry = null;
                        for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
                            if (!entry.getId().equals(childNodeId)) continue;
                            childNodeEntry = entry;
                            break;
                        }
                        if (childNodeEntry != null) {
                            String message = "NodeState '" + id + "' references inexistent child '" + childNodeId + "'";
                            log.error(message);
                            this.addMessage(reports, id, message, ReportItem.Type.MISSING);
                            missingChildren.add(childNodeEntry);
                        }
                    } else {
                        childNodeInfo = new NodeInfo(childBundle);
                    }
                }
                if (childNodeInfo == null || id.equals(cp = childNodeInfo.getParentId())) continue;
                if (childBundle == null) {
                    childBundle = this.pm.loadBundle(childNodeId);
                }
                if (childBundle == null || childBundle.getParentId().equals(id)) continue;
                if (bundle == null) {
                    bundle = this.pm.loadBundle(id);
                }
                if (bundle == null) return;
                NodePropBundle.ChildNodeEntry childNodeEntry = null;
                for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
                    if (!entry.getId().equals(childNodeId)) continue;
                    childNodeEntry = entry;
                    break;
                }
                if (childNodeEntry == null) continue;
                String message = "Node has invalid parent id: '" + cp + "' (instead of '" + id + "')";
                log.error(message);
                this.addMessage(reports, childNodeId, message, ReportItem.Type.DISCONNECTED);
                disconnectedChildren.add(childNodeEntry);
            }
            catch (ItemStateException e) {
                this.addMessage(reports, id, e.getMessage(), ReportItem.Type.ERROR);
            }
        }
        if (!(!fix || missingChildren.isEmpty() && disconnectedChildren.isEmpty())) {
            for (NodePropBundle.ChildNodeEntry entry : missingChildren) {
                bundle.getChildNodeEntries().remove(entry);
            }
            for (NodePropBundle.ChildNodeEntry entry : disconnectedChildren) {
                bundle.getChildNodeEntries().remove(entry);
            }
            this.fixBundle(bundle);
        }
        NodeId parentId = nodeInfo.getParentId();
        try {
            if (parentId == null) return;
            if (id.toString().endsWith("babecafebabe")) return;
            NodePropBundle parentBundle = null;
            NodeInfo parentInfo = infos.get(parentId);
            if (parentInfo == null) {
                parentBundle = this.pm.loadBundle(parentId);
                if (parentBundle == null) {
                    if (bundle == null) {
                        bundle = this.pm.loadBundle(id);
                    }
                    if (bundle == null) return;
                    if (parentId.equals(bundle.getParentId())) {
                        String message = "NodeState '" + id + "' references inexistent parent id '" + parentId + "'";
                        log.error(message);
                        this.addMessage(reports, id, message, ReportItem.Type.ORPHANED);
                        if (fix && lostNFoundId != null) {
                            NodePropBundle lfBundle = this.pm.loadBundle(lostNFoundId);
                            lfBundle.markOld();
                            String nodeName = id + "-" + System.currentTimeMillis();
                            lfBundle.addChildNodeEntry(NF.create("", nodeName), id);
                            this.pm.storeBundle(lfBundle);
                            this.pm.evictBundle(lostNFoundId);
                            bundle.setParentId(lostNFoundId);
                            this.fixBundle(bundle);
                        }
                    }
                } else {
                    parentInfo = new NodeInfo(parentBundle);
                }
            }
            if (parentInfo == null) return;
            boolean found = false;
            for (NodeId childNodeId : parentInfo.getChildren()) {
                if (!childNodeId.equals(id)) continue;
                return;
            }
            if (!found && parentBundle == null && (parentBundle = this.pm.loadBundle(parentId)) != null) {
                for (NodePropBundle.ChildNodeEntry entry : parentBundle.getChildNodeEntries()) {
                    if (!entry.getId().equals(id)) continue;
                    return;
                }
            }
            if (found) return;
            if (bundle == null) {
                bundle = this.pm.loadBundle(id);
            }
            if (bundle == null) return;
            if (!parentId.equals(bundle.getParentId())) return;
            String message = "NodeState '" + id + "' is not referenced by its parent node '" + parentId + "'";
            log.error(message);
            this.addMessage(reports, id, message, ReportItem.Type.ABANDONED);
            if (!fix) return;
            int l = (int)System.currentTimeMillis();
            int r = new Random().nextInt();
            int n = l + r;
            String nodeName = Integer.toHexString(n);
            parentBundle.addChildNodeEntry(NF.create("{}" + nodeName), id);
            log.info("NodeState '" + id + "' adds itself to its parent node '" + parentId + "' with a new name '" + nodeName + "'");
            this.fixBundle(parentBundle);
            return;
        }
        catch (ItemStateException e) {
            String message = "Error reading node '" + parentId + "' (parent of '" + id + "'): " + e;
            log.error(message);
            this.addMessage(reports, id, message, ReportItem.Type.ERROR);
        }
    }

    private boolean isVirtualNode(NodeId id) {
        String s = id.toString();
        return !this.isRoot(s) && s.endsWith("babecafebabe");
    }

    private boolean isRoot(String id) {
        return "cafebabe-cafe-babe-cafe-babecafebabe".equals(id);
    }

    private void addMessage(Set<ReportItem> reports, NodeId id, String message, ReportItem.Type type) {
        if (reports != null || this.listener != null) {
            ReportItemImpl ri = new ReportItemImpl(id.toString(), message, type);
            if (reports != null) {
                reports.add(ri);
            }
            if (this.listener != null) {
                this.listener.report(ri);
            }
        }
    }

    private void info(String id, String message) {
        if (this.listener == null) {
            String idstring = id == null ? "" : "Node " + id + ": ";
            log.info(idstring + message);
        } else {
            this.listener.info(id, message);
        }
    }

    private void error(String id, String message) {
        if (this.listener == null) {
            String idstring = id == null ? "" : "Node " + id + ": ";
            log.error(idstring + message);
        } else {
            this.listener.error(id, message);
        }
    }

    private void error(String id, String message, Throwable ex) {
        String idstring = id == null ? "" : "Node " + id + ": ";
        log.error(idstring + message, ex);
        if (this.listener != null) {
            this.listener.error(id, message);
        }
    }

    private void fixBundle(NodePropBundle bundle) {
        try {
            log.info(this.pm + ": Fixing bundle '" + bundle.getId() + "'");
            bundle.markOld();
            this.pm.storeBundle(bundle);
            this.pm.evictBundle(bundle.getId());
        }
        catch (ItemStateException e) {
            log.error(this.pm + ": Error storing fixed bundle: " + e);
        }
    }
}

