/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.FitNesse;
import fitnesse.FitNesseVersion;
import fitnesse.authentication.Authenticator;
import fitnesse.components.Logger;
import fitnesse.html.template.PageFactory;
import fitnesse.responders.ResponderFactory;
import fitnesse.testrunner.RunningTestingTracker;
import fitnesse.testsystems.TestSystemFactory;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.wiki.RecentChanges;
import fitnesse.wiki.SystemVariableSource;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.fs.VersionsController;
import java.io.File;
import java.util.Properties;

public class FitNesseContext {
    public static final String recentChangesDateFormat = "kk:mm:ss EEE, MMM dd, yyyy";
    public static final String rfcCompliantDateFormat = "EEE, d MMM yyyy HH:mm:ss Z";
    public static final String testResultsDirectoryName = "testResults";
    public final FitNesseVersion version;
    public final FitNesse fitNesse;
    public final WikiPage root;
    public final TestSystemFactory testSystemFactory;
    public final TestSystemListener testSystemListener;
    public final RunningTestingTracker runningTestingTracker;
    public final int port;
    public final String rootPath;
    private final String rootDirectoryName;
    public final String contextRoot;
    public final ResponderFactory responderFactory;
    public final PageFactory pageFactory;
    public final SystemVariableSource variableSource;
    public final VersionsController versionsController;
    public final RecentChanges recentChanges;
    public final Logger logger;
    public final Authenticator authenticator;
    private final Properties properties;

    protected FitNesseContext(FitNesseVersion version, WikiPage root, String rootPath, String rootDirectoryName, String contextRoot, VersionsController versionsController, RecentChanges recentChanges, int port, Authenticator authenticator, Logger logger, TestSystemFactory testSystemFactory, TestSystemListener testSystemListener, Properties properties) {
        this.version = version;
        this.root = root;
        this.rootPath = rootPath;
        this.rootDirectoryName = rootDirectoryName;
        this.contextRoot = contextRoot;
        this.versionsController = versionsController;
        this.recentChanges = recentChanges;
        this.port = port;
        this.authenticator = authenticator;
        this.logger = logger;
        this.testSystemFactory = testSystemFactory;
        this.testSystemListener = testSystemListener;
        this.properties = properties;
        this.runningTestingTracker = new RunningTestingTracker();
        this.responderFactory = new ResponderFactory(this.getRootPagePath());
        this.variableSource = new SystemVariableSource(properties);
        this.fitNesse = new FitNesse(this);
        this.pageFactory = new PageFactory(this);
    }

    public File getTestHistoryDirectory() {
        return new File(String.format("%s/files/%s", this.getRootPagePath(), testResultsDirectoryName));
    }

    public String getTestProgressPath() {
        return String.format("%s/files/testProgress/", this.getRootPagePath());
    }

    public String getRootPagePath() {
        return String.format("%s%s%s", this.rootPath, File.separator, this.rootDirectoryName);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.variableSource.getProperty(name);
    }
}

