package com.xebialabs.xltest.serialize;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.DatatypeConverter;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONWriter;
import org.springframework.stereotype.Component;

import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.view.ListOfTestRuns;

@Component
@Provider
@Produces({MediaType.APPLICATION_JSON})
public class ListOfTestRunsWriter extends BasicMessageBodyWriter<ListOfTestRuns> {

    protected void writeJson(final ListOfTestRuns testRuns, final JSONWriter writer) throws JSONException {
        writer.array();
        for (TestRun testRun : testRuns) {
            writeJson(testRun, writer);
        }
        writer.endArray();
    }

    protected void writeJson(final TestRun testRun, final JSONWriter writer) throws JSONException {
        writer.object();
        writer.key("id").value(testRun.getId());
        writer.key("startTime").value(convert(testRun.getStartTime()));
        writer.key("finishedTime").value(convert(testRun.getFinishedTime()));
        writer.key("qualificationResult").value(testRun.getQualificationResult());
        writer.key("testSpecificationName").value(testRun.getTestSpecificationName());
        writer.endObject();
    }

    private String convert(Date value) {
        if (value == null) return null;
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(value);
        return DatatypeConverter.printDateTime(cal);
    }

}
