package com.xebialabs.xltest.serialize.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;
import com.google.common.annotations.VisibleForTesting;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xltype.serialization.json.JsonWriter;

import static com.xebialabs.xltest.serialize.metadata.PropertyDescriptorJsonWriter.writePropertyDescriptor;

@Component
@Provider
@Produces({MediaType.APPLICATION_JSON})
public class DescriptorJsonWriter implements MessageBodyWriter<Descriptor> {

    @Override
    public boolean isWriteable(final Class<?> type, final java.lang.reflect.Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return true;
    }

    @Override
    public long getSize(final Descriptor descriptor, final Class<?> type, final java.lang.reflect.Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return -1L;
    }


    @Override
    public void writeTo(final Descriptor descriptor, final Class<?> type, final java.lang.reflect.Type genericType, final Annotation[] annotations, final MediaType mediaType, final MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(descriptor).getBytes());
    }

    @VisibleForTesting
    String toJson(Descriptor descriptor) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);
        writeJson(descriptor, writer);
        return stringWriter.toString();
    }

    public void writeJson(final Descriptor descriptor, final JsonWriter writer) {
        writer.object();
        writer.key("type").value(descriptor.getType().toString());
        writer.key("name").value(descriptor.getType().getName());
        writeSuperTypes(writer, descriptor);
//        if (descriptor.getContainerType() != null) {
//            writer.key("containerType").value(descriptor.getContainerType().toString());
//        }
//        if (descriptor.getDeployableType() != null) {
//            writer.key("deployableType").value(descriptor.getDeployableType().toString());
//        }
        writer.key("virtual").value(descriptor.isVirtual());
        if (!descriptor.isVirtual() && descriptor.getRoot().getRootNodeName() != null) {
            writer.key("root").value(descriptor.getRoot().getRootNodeName());
        }
        writer.key("description").value(descriptor.getDescription());

        writePropertyDescriptors(writer, descriptor);
        writer.endObject();
    }

    private void writeSuperTypes(JsonWriter writer, Descriptor descriptor) {
        writer.key("extends");
        writer.array();
        for (Type superType : descriptor.getSuperClasses()) {
            if (!"BaseConfigurationItem".equals(superType.getName()))
                writer.value(superType.toString());
        }
        writer.endArray();
    }

    private static void writePropertyDescriptors(JsonWriter writer, Descriptor descriptor) {
        writer.key("properties");
        writer.array();

        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            writePropertyDescriptor(writer, pd);
        }

        writer.endArray();
    }
}
