/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class BulkItemRequest
implements Streamable {
    private int id;
    private ActionRequest request;

    BulkItemRequest() {
    }

    public BulkItemRequest(int id, ActionRequest request) {
        this.id = id;
        this.request = request;
    }

    public int id() {
        return this.id;
    }

    public ActionRequest request() {
        return this.request;
    }

    public static BulkItemRequest readBulkItem(StreamInput in) throws IOException {
        BulkItemRequest item = new BulkItemRequest();
        item.readFrom(in);
        return item;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.id = in.readVInt();
        byte type = in.readByte();
        if (type == 0) {
            this.request = new IndexRequest();
        } else if (type == 1) {
            this.request = new DeleteRequest();
        } else if (type == 2) {
            this.request = new UpdateRequest();
        }
        this.request.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        if (this.request instanceof IndexRequest) {
            out.writeByte((byte)0);
        } else if (this.request instanceof DeleteRequest) {
            out.writeByte((byte)1);
        } else if (this.request instanceof UpdateRequest) {
            out.writeByte((byte)2);
        }
        this.request.writeTo(out);
    }
}

