/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.util.Set;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParser;

public class ScoreFunctionParserMapper {
    protected ImmutableMap<String, ScoreFunctionParser> functionParsers;

    @Inject
    public ScoreFunctionParserMapper(Set<ScoreFunctionParser> parsers) {
        MapBuilder<String, ScoreFunctionParser> builder = MapBuilder.newMapBuilder();
        for (ScoreFunctionParser scoreFunctionParser : parsers) {
            for (String name : scoreFunctionParser.getNames()) {
                builder.put(name, scoreFunctionParser);
            }
        }
        this.functionParsers = builder.immutableMap();
    }

    public ScoreFunctionParser get(Index index, String parserName) {
        ScoreFunctionParser functionParser = this.get(parserName);
        if (functionParser == null) {
            throw new QueryParsingException(index, "No function with the name [" + parserName + "] is registered.");
        }
        return functionParser;
    }

    private ScoreFunctionParser get(String parserName) {
        return this.functionParsers.get(parserName);
    }
}

