/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.suggest.SuggestBuilder;

public final class PhraseSuggestionBuilder
extends SuggestBuilder.SuggestionBuilder<PhraseSuggestionBuilder> {
    private Float maxErrors;
    private String separator;
    private Float realWordErrorLikelihood;
    private Float confidence;
    private final Map<String, List<CandidateGenerator>> generators = new HashMap<String, List<CandidateGenerator>>();
    private Integer gramSize;
    private SmoothingModel model;
    private Boolean forceUnigrams;
    private Integer tokenLimit;
    private String preTag;
    private String postTag;
    private String collateQuery;
    private String collateFilter;
    private String collatePreference;
    private Map<String, Object> collateParams;

    public PhraseSuggestionBuilder(String name) {
        super(name, "phrase");
    }

    public PhraseSuggestionBuilder gramSize(int gramSize) {
        if (gramSize < 1) {
            throw new ElasticsearchIllegalArgumentException("gramSize must be >= 1");
        }
        this.gramSize = gramSize;
        return this;
    }

    public PhraseSuggestionBuilder maxErrors(Float maxErrors) {
        this.maxErrors = maxErrors;
        return this;
    }

    public PhraseSuggestionBuilder separator(String separator) {
        this.separator = separator;
        return this;
    }

    public PhraseSuggestionBuilder realWordErrorLikelihood(Float realWordErrorLikelihood) {
        this.realWordErrorLikelihood = realWordErrorLikelihood;
        return this;
    }

    public PhraseSuggestionBuilder confidence(Float confidence) {
        this.confidence = confidence;
        return this;
    }

    public PhraseSuggestionBuilder addCandidateGenerator(CandidateGenerator generator) {
        List<CandidateGenerator> list = this.generators.get(generator.getType());
        if (list == null) {
            list = new ArrayList<CandidateGenerator>();
            this.generators.put(generator.getType(), list);
        }
        list.add(generator);
        return this;
    }

    public PhraseSuggestionBuilder clearCandidateGenerators() {
        this.generators.clear();
        return this;
    }

    public PhraseSuggestionBuilder forceUnigrams(boolean forceUnigrams) {
        this.forceUnigrams = forceUnigrams;
        return this;
    }

    public PhraseSuggestionBuilder smoothingModel(SmoothingModel model) {
        this.model = model;
        return this;
    }

    public PhraseSuggestionBuilder tokenLimit(int tokenLimit) {
        this.tokenLimit = tokenLimit;
        return this;
    }

    public PhraseSuggestionBuilder highlight(String preTag, String postTag) {
        if (preTag == null != (postTag == null)) {
            throw new ElasticsearchIllegalArgumentException("Pre and post tag must both be null or both not be null.");
        }
        this.preTag = preTag;
        this.postTag = postTag;
        return this;
    }

    public PhraseSuggestionBuilder collateQuery(String collateQuery) {
        this.collateQuery = collateQuery;
        return this;
    }

    public PhraseSuggestionBuilder collateFilter(String collateFilter) {
        this.collateFilter = collateFilter;
        return this;
    }

    public PhraseSuggestionBuilder collatePreference(String collatePreference) {
        this.collatePreference = collatePreference;
        return this;
    }

    public PhraseSuggestionBuilder collateParams(Map<String, Object> collateParams) {
        this.collateParams = collateParams;
        return this;
    }

    @Override
    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.realWordErrorLikelihood != null) {
            builder.field("real_word_error_likelihood", this.realWordErrorLikelihood);
        }
        if (this.confidence != null) {
            builder.field("confidence", this.confidence);
        }
        if (this.separator != null) {
            builder.field("separator", this.separator);
        }
        if (this.maxErrors != null) {
            builder.field("max_errors", this.maxErrors);
        }
        if (this.gramSize != null) {
            builder.field("gram_size", this.gramSize);
        }
        if (this.forceUnigrams != null) {
            builder.field("force_unigrams", (Object)this.forceUnigrams);
        }
        if (this.tokenLimit != null) {
            builder.field("token_limit", this.tokenLimit);
        }
        if (!this.generators.isEmpty()) {
            Set<Map.Entry<String, List<CandidateGenerator>>> entrySet = this.generators.entrySet();
            for (Map.Entry<String, List<CandidateGenerator>> entry : entrySet) {
                builder.startArray(entry.getKey());
                for (CandidateGenerator generator : entry.getValue()) {
                    generator.toXContent(builder, params);
                }
                builder.endArray();
            }
        }
        if (this.model != null) {
            builder.startObject("smoothing");
            this.model.toXContent(builder, params);
            builder.endObject();
        }
        if (this.preTag != null) {
            builder.startObject("highlight");
            builder.field("pre_tag", this.preTag);
            builder.field("post_tag", this.postTag);
            builder.endObject();
        }
        if (this.collateQuery != null || this.collateFilter != null) {
            builder.startObject("collate");
            if (this.collateQuery != null) {
                builder.field("query", this.collateQuery);
            }
            if (this.collateFilter != null) {
                builder.field("filter", this.collateFilter);
            }
            if (this.collatePreference != null) {
                builder.field("preference", this.collatePreference);
            }
            if (this.collateParams != null) {
                builder.field("params", this.collateParams);
            }
            builder.endObject();
        }
        return builder;
    }

    public static DirectCandidateGenerator candidateGenerator(String field) {
        return new DirectCandidateGenerator(field);
    }

    public static final class DirectCandidateGenerator
    extends CandidateGenerator {
        private final String field;
        private String preFilter;
        private String postFilter;
        private String suggestMode;
        private Float accuracy;
        private Integer size;
        private String sort;
        private String stringDistance;
        private Integer maxEdits;
        private Integer maxInspections;
        private Float maxTermFreq;
        private Integer prefixLength;
        private Integer minWordLength;
        private Float minDocFreq;

        public DirectCandidateGenerator(String field) {
            super("direct_generator");
            this.field = field;
        }

        public DirectCandidateGenerator suggestMode(String suggestMode) {
            this.suggestMode = suggestMode;
            return this;
        }

        public DirectCandidateGenerator accuracy(float accuracy) {
            this.accuracy = Float.valueOf(accuracy);
            return this;
        }

        public DirectCandidateGenerator size(int size) {
            if (size <= 0) {
                throw new ElasticsearchIllegalArgumentException("Size must be positive");
            }
            this.size = size;
            return this;
        }

        public DirectCandidateGenerator sort(String sort) {
            this.sort = sort;
            return this;
        }

        public DirectCandidateGenerator stringDistance(String stringDistance) {
            this.stringDistance = stringDistance;
            return this;
        }

        public DirectCandidateGenerator maxEdits(Integer maxEdits) {
            this.maxEdits = maxEdits;
            return this;
        }

        public DirectCandidateGenerator maxInspections(Integer maxInspections) {
            this.maxInspections = maxInspections;
            return this;
        }

        public DirectCandidateGenerator maxTermFreq(float maxTermFreq) {
            this.maxTermFreq = Float.valueOf(maxTermFreq);
            return this;
        }

        public DirectCandidateGenerator prefixLength(int prefixLength) {
            this.prefixLength = prefixLength;
            return this;
        }

        public DirectCandidateGenerator minWordLength(int minWordLength) {
            this.minWordLength = minWordLength;
            return this;
        }

        public DirectCandidateGenerator minDocFreq(float minDocFreq) {
            this.minDocFreq = Float.valueOf(minDocFreq);
            return this;
        }

        public DirectCandidateGenerator preFilter(String preFilter) {
            this.preFilter = preFilter;
            return this;
        }

        public DirectCandidateGenerator postFilter(String postFilter) {
            this.postFilter = postFilter;
            return this;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.field != null) {
                builder.field("field", this.field);
            }
            if (this.suggestMode != null) {
                builder.field("suggest_mode", this.suggestMode);
            }
            if (this.accuracy != null) {
                builder.field("accuracy", this.accuracy);
            }
            if (this.size != null) {
                builder.field("size", this.size);
            }
            if (this.sort != null) {
                builder.field("sort", this.sort);
            }
            if (this.stringDistance != null) {
                builder.field("string_distance", this.stringDistance);
            }
            if (this.maxEdits != null) {
                builder.field("max_edits", this.maxEdits);
            }
            if (this.maxInspections != null) {
                builder.field("max_inspections", this.maxInspections);
            }
            if (this.maxTermFreq != null) {
                builder.field("max_term_freq", this.maxTermFreq);
            }
            if (this.prefixLength != null) {
                builder.field("prefix_length", this.prefixLength);
            }
            if (this.minWordLength != null) {
                builder.field("min_word_length", this.minWordLength);
            }
            if (this.minDocFreq != null) {
                builder.field("min_doc_freq", this.minDocFreq);
            }
            if (this.preFilter != null) {
                builder.field("pre_filter", this.preFilter);
            }
            if (this.postFilter != null) {
                builder.field("post_filter", this.postFilter);
            }
            builder.endObject();
            return builder;
        }
    }

    public static abstract class CandidateGenerator
    implements ToXContent {
        private final String type;

        public CandidateGenerator(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    public static final class LinearInterpolation
    extends SmoothingModel {
        private final double trigramLambda;
        private final double bigramLambda;
        private final double unigramLambda;

        public LinearInterpolation(double trigramLambda, double bigramLambda, double unigramLambda) {
            super("linear");
            this.trigramLambda = trigramLambda;
            this.bigramLambda = bigramLambda;
            this.unigramLambda = unigramLambda;
        }

        @Override
        protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("trigram_lambda", this.trigramLambda);
            builder.field("bigram_lambda", this.bigramLambda);
            builder.field("unigram_lambda", this.unigramLambda);
            return builder;
        }
    }

    public static abstract class SmoothingModel
    implements ToXContent {
        private final String type;

        protected SmoothingModel(String type) {
            this.type = type;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.type);
            this.innerToXContent(builder, params);
            builder.endObject();
            return builder;
        }

        protected abstract XContentBuilder innerToXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;
    }

    public static final class Laplace
    extends SmoothingModel {
        private final double alpha;

        public Laplace(double alpha) {
            super("laplace");
            this.alpha = alpha;
        }

        @Override
        protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("alpha", this.alpha);
            return builder;
        }
    }

    public static final class StupidBackoff
    extends SmoothingModel {
        private final double discount;

        public StupidBackoff(double discount) {
            super("stupid_backoff");
            this.discount = discount;
        }

        @Override
        protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("discount", this.discount);
            return builder;
        }
    }
}

