/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyObject;

public class PyCallIter
extends PyIterator {
    private PyObject callable;
    private PyObject sentinel;

    public PyCallIter(PyObject callable, PyObject sentinel) {
        if (!callable.isCallable()) {
            throw Py.TypeError("iter(v, w): v must be callable");
        }
        this.callable = callable;
        this.sentinel = sentinel;
    }

    @Override
    public PyObject __iternext__() {
        PyObject result;
        if (this.callable == null) {
            return null;
        }
        try {
            result = this.callable.__call__();
        }
        catch (PyException exc) {
            if (exc.match(Py.StopIteration)) {
                this.callable = null;
                this.stopException = exc;
                return null;
            }
            throw exc;
        }
        if (result._eq(this.sentinel).__nonzero__()) {
            this.callable = null;
            return null;
        }
        return result;
    }
}

