package com.xebialabs.xltest;


import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

import com.xebialabs.deployit.booter.local.LocalBooter;

import static java.lang.System.out;

public class Main {

    public static Object booter;

    public static void main(String[] args) throws Exception {

        Spinner spinner = new Spinner("Starting XL Test");
        spinner.start();
        XLTest xltest;
        try {
            startInProcessElasticSearch();

            LocalBooter.boot();

            xltest = new XLTest();
            xltest.startWebApp();

        } finally {
            spinner.done();
        }

        out.println("");
        out.println(String.format("Please open http://localhost:%d with a modern browser.", xltest.webAppPortNumber()));
        out.println("");
    }

    public static void startInProcessElasticSearch() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        File f = new File("lib/elasticsearch");
        final ClassLoader classLoader = newInstance(f);

        Class<?> elasticSearchBooterClass = classLoader.loadClass("com.xebialabs.xltest.elasticsearch.ElasticSearchBooter");
        booter = elasticSearchBooterClass.newInstance();
    }

    private static ClassLoader newInstance(File libraryDirectory) {
        File[] jars = libraryDirectory.listFiles();
        URL[] urls = new URL[jars.length];
        for (int i = 0; i < jars.length; i++) {
            try {
                urls[i] = jars[i].toURI().toURL();
            } catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        // explicitly set parent classloader to null, otherwise a lookup is done FIRST using the system classloader...
        return new URLClassLoader(urls, null);
    }
}

class Spinner extends Thread {
    private final String message;
    private volatile boolean showProgress = true;

    Spinner(String message) {
        this.message = message;
        setDaemon(true);
    }

    public void done() {
        showProgress = false;
        while (this.isAlive()) {
            sleepOnIt();
        }
    }

    public void run() {
        String anim = "\\-/|";
        int x = 0;
        while (showProgress) {
            out.print("\r" + message + " ... " + anim.charAt(x++ % anim.length()));
            sleepOnIt();
        }
        out.println("\r" + message + " ... done.");
    }

    public void sleepOnIt() {
        try {
            Thread.sleep(100);
        } catch (Exception e) {
        }
    }
}