package com.xebialabs.xltest;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class XLTestManifest {

    private final String manifestVersion;
    private final String name;
    private final String vendor;
    private final String version;
    private final String build;

    public XLTestManifest() {
        this(XLTestManifest.class);
    }

    public XLTestManifest(Class clazz) {
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            manifestVersion = name = vendor = version = build = "DEVELOP";
            return;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) +
                "/META-INF/MANIFEST.MF";
        Manifest manifest;
        try {
            InputStream inputStream = new URL(manifestPath).openStream();
            manifest = new Manifest(inputStream);
            inputStream.close();
        } catch (IOException e) {
            throw new RuntimeException("Can not find XL Test application information", e);
        }
        Attributes attr = manifest.getMainAttributes();
        manifestVersion = attr.getValue("Manifest-Version");
        build = attr.getValue("Implementation-Version");
        name = attr.getValue("Specification-Title");
        version = attr.getValue("Specification-Version");
        vendor = attr.getValue("Specification-Vendor");
    }

    public String getManifestVersion() {
        return manifestVersion;
    }

    public String getBuild() {
        return build;
    }

    public String getName() {
        return name;
    }

    public String getVendor() {
        return vendor;
    }

    public String getVersion() {
        return version;
    }
}
