package com.xebialabs.xltest.domain;

import java.util.Date;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

@SuppressWarnings("serial")
@Metadata(description = "A dashbard", root = Metadata.ConfigurationItemRoot.CONFIGURATION)
public class Dashboard extends ScriptedConfigurationItem {

    @Property(description = "Comma separated list of tool categories this dashboard can handle, such as 'functional, performance'")
    private List<String> toolCategories;

    @Property(asContainment = true, required = false)
    private List<ReportHolder> reportHolders;

    @Property(isTransient = true)
    private TestSpecification testSpecification;

    @Property(isTransient = true)
    private Date date;

    public List<ReportHolder> getReportHolders() {
        return reportHolders;
    }

    public void setReportHolders(List<ReportHolder> reportHolders) {
        this.reportHolders = reportHolders;
    }

    public List<String> getToolCategories() {
        return toolCategories;
    }

    public void setToolCategories(List<String> toolCategories) {
        this.toolCategories = toolCategories;
    }

    public TestSpecification getTestSpecification() {
        return testSpecification;
    }

    public void setTestSpecification(TestSpecification testSpecification) {
        this.testSpecification = testSpecification;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
}
