/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import org.elasticsearch.ElasticsearchIllegalArgumentException;

public enum VersionType {
    INTERNAL(0){

        @Override
        public boolean isVersionConflictForWrites(long currentVersion, long expectedVersion) {
            return this.isVersionConflict(currentVersion, expectedVersion);
        }

        @Override
        public boolean isVersionConflictForReads(long currentVersion, long expectedVersion) {
            return this.isVersionConflict(currentVersion, expectedVersion);
        }

        private boolean isVersionConflict(long currentVersion, long expectedVersion) {
            if (currentVersion == -2L) {
                return false;
            }
            if (expectedVersion == -3L || expectedVersion == 0L) {
                return false;
            }
            if (currentVersion == -1L) {
                return true;
            }
            return currentVersion != expectedVersion;
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return currentVersion == -2L || currentVersion == -1L ? 1L : currentVersion + 1L;
        }

        @Override
        public boolean validateVersionForWrites(long version) {
            return version > 0L || version == -3L || version == 0L;
        }

        @Override
        public boolean validateVersionForReads(long version) {
            return version > 0L || version == -3L || version == 0L;
        }

        @Override
        public VersionType versionTypeForReplicationAndRecovery() {
            return EXTERNAL;
        }
    }
    ,
    EXTERNAL(1){

        @Override
        public boolean isVersionConflictForWrites(long currentVersion, long expectedVersion) {
            if (currentVersion == -2L) {
                return false;
            }
            if (currentVersion == -1L) {
                return false;
            }
            if (expectedVersion == -3L) {
                return true;
            }
            return currentVersion >= expectedVersion;
        }

        @Override
        public boolean isVersionConflictForReads(long currentVersion, long expectedVersion) {
            if (currentVersion == -2L) {
                return false;
            }
            if (expectedVersion == -3L) {
                return false;
            }
            if (currentVersion == -1L) {
                return true;
            }
            return currentVersion != expectedVersion;
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return expectedVersion;
        }

        @Override
        public boolean validateVersionForWrites(long version) {
            return version >= 0L;
        }

        @Override
        public boolean validateVersionForReads(long version) {
            return version >= 0L || version == -3L;
        }
    }
    ,
    EXTERNAL_GTE(2){

        @Override
        public boolean isVersionConflictForWrites(long currentVersion, long expectedVersion) {
            if (currentVersion == -2L) {
                return false;
            }
            if (currentVersion == -1L) {
                return false;
            }
            if (expectedVersion == -3L) {
                return true;
            }
            return currentVersion > expectedVersion;
        }

        @Override
        public boolean isVersionConflictForReads(long currentVersion, long expectedVersion) {
            if (currentVersion == -2L) {
                return false;
            }
            if (expectedVersion == -3L) {
                return false;
            }
            if (currentVersion == -1L) {
                return true;
            }
            return currentVersion != expectedVersion;
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return expectedVersion;
        }

        @Override
        public boolean validateVersionForWrites(long version) {
            return version >= 0L;
        }

        @Override
        public boolean validateVersionForReads(long version) {
            return version >= 0L || version == -3L;
        }
    }
    ,
    FORCE(3){

        @Override
        public boolean isVersionConflictForWrites(long currentVersion, long expectedVersion) {
            if (currentVersion == -2L) {
                return false;
            }
            if (currentVersion == -1L) {
                return false;
            }
            return expectedVersion == -3L;
        }

        @Override
        public boolean isVersionConflictForReads(long currentVersion, long expectedVersion) {
            return false;
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return expectedVersion;
        }

        @Override
        public boolean validateVersionForWrites(long version) {
            return version >= 0L;
        }

        @Override
        public boolean validateVersionForReads(long version) {
            return version >= 0L || version == -3L;
        }
    };

    private final byte value;

    private VersionType(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public abstract boolean isVersionConflictForWrites(long var1, long var3);

    public abstract boolean isVersionConflictForReads(long var1, long var3);

    public abstract long updateVersion(long var1, long var3);

    public abstract boolean validateVersionForWrites(long var1);

    public abstract boolean validateVersionForReads(long var1);

    public VersionType versionTypeForReplicationAndRecovery() {
        return this;
    }

    public static VersionType fromString(String versionType) {
        if ("internal".equals(versionType)) {
            return INTERNAL;
        }
        if ("external".equals(versionType)) {
            return EXTERNAL;
        }
        if ("external_gt".equals(versionType)) {
            return EXTERNAL;
        }
        if ("external_gte".equals(versionType)) {
            return EXTERNAL_GTE;
        }
        if ("force".equals(versionType)) {
            return FORCE;
        }
        throw new ElasticsearchIllegalArgumentException("No version type match [" + versionType + "]");
    }

    public static VersionType fromString(String versionType, VersionType defaultVersionType) {
        if (versionType == null) {
            return defaultVersionType;
        }
        return VersionType.fromString(versionType);
    }

    public static VersionType fromValue(byte value) {
        if (value == 0) {
            return INTERNAL;
        }
        if (value == 1) {
            return EXTERNAL;
        }
        if (value == 2) {
            return EXTERNAL_GTE;
        }
        if (value == 3) {
            return FORCE;
        }
        throw new ElasticsearchIllegalArgumentException("No version type match [" + value + "]");
    }
}

