/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.XOrdinalMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalMapping;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;

final class InternalGlobalOrdinalsIndexFieldData
extends GlobalOrdinalsIndexFieldData {
    private final Atomic[] atomicReaders;

    InternalGlobalOrdinalsIndexFieldData(Index index, Settings settings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, AtomicFieldData.WithOrdinals[] segmentAfd, XOrdinalMap ordinalMap, long memorySizeInBytes) {
        super(index, settings, fieldNames, fieldDataType, memorySizeInBytes);
        this.atomicReaders = new Atomic[segmentAfd.length];
        for (int i = 0; i < segmentAfd.length; ++i) {
            this.atomicReaders[i] = new Atomic(segmentAfd[i], ordinalMap, i);
        }
    }

    @Override
    public AtomicFieldData.WithOrdinals load(AtomicReaderContext context) {
        return this.atomicReaders[context.ord];
    }

    private final class Atomic
    implements AtomicFieldData.WithOrdinals {
        private final AtomicFieldData.WithOrdinals afd;
        private final XOrdinalMap ordinalMap;
        private final int segmentIndex;

        private Atomic(AtomicFieldData.WithOrdinals afd, XOrdinalMap ordinalMap, int segmentIndex) {
            this.afd = afd;
            this.ordinalMap = ordinalMap;
            this.segmentIndex = segmentIndex;
        }

        @Override
        public BytesValues.WithOrdinals getBytesValues() {
            BytesValues.WithOrdinals values = this.afd.getBytesValues();
            if (values.getMaxOrd() == this.ordinalMap.getValueCount()) {
                return values;
            }
            BytesValues.WithOrdinals[] bytesValues = new BytesValues.WithOrdinals[InternalGlobalOrdinalsIndexFieldData.this.atomicReaders.length];
            for (int i = 0; i < bytesValues.length; ++i) {
                bytesValues[i] = ((InternalGlobalOrdinalsIndexFieldData)InternalGlobalOrdinalsIndexFieldData.this).atomicReaders[i].afd.getBytesValues();
            }
            return new GlobalOrdinalMapping(this.ordinalMap, bytesValues, this.segmentIndex);
        }

        public long ramBytesUsed() {
            return this.afd.ramBytesUsed();
        }

        @Override
        public ScriptDocValues getScriptValues() {
            throw new UnsupportedOperationException("Script values not supported on global ordinals");
        }

        @Override
        public void close() {
        }
    }
}

