/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.hppc.LongLongOpenHashMap;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.rounding.TimeZoneRounding;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.LongFacetAggregatorBase;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalCountDateHistogramFacet;

public class CountDateHistogramFacetExecutor
extends FacetExecutor {
    private final TimeZoneRounding tzRounding;
    private final IndexNumericFieldData indexFieldData;
    final DateHistogramFacet.ComparatorType comparatorType;
    final Recycler.V<LongLongOpenHashMap> counts;

    public CountDateHistogramFacetExecutor(IndexNumericFieldData indexFieldData, TimeZoneRounding tzRounding, DateHistogramFacet.ComparatorType comparatorType, CacheRecycler cacheRecycler) {
        this.comparatorType = comparatorType;
        this.indexFieldData = indexFieldData;
        this.tzRounding = tzRounding;
        this.counts = cacheRecycler.longLongMap(-1);
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        InternalCountDateHistogramFacet.CountEntry[] countEntries = new InternalCountDateHistogramFacet.CountEntry[this.counts.v().size()];
        boolean[] states = this.counts.v().allocated;
        long[] keys = this.counts.v().keys;
        long[] values = this.counts.v().values;
        int entryIndex = 0;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            countEntries[entryIndex++] = new InternalCountDateHistogramFacet.CountEntry(keys[i], values[i]);
        }
        this.counts.close();
        return new InternalCountDateHistogramFacet(facetName, this.comparatorType, countEntries);
    }

    public static class DateHistogramProc
    extends LongFacetAggregatorBase {
        private final LongLongOpenHashMap counts;
        private final TimeZoneRounding tzRounding;

        public DateHistogramProc(LongLongOpenHashMap counts, TimeZoneRounding tzRounding) {
            this.counts = counts;
            this.tzRounding = tzRounding;
        }

        @Override
        public void onValue(int docId, long value) {
            this.counts.addTo(this.tzRounding.round(value), 1L);
        }

        public LongLongOpenHashMap counts() {
            return this.counts;
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private LongValues values;
        private final DateHistogramProc histoProc;

        public Collector() {
            this.histoProc = new DateHistogramProc(CountDateHistogramFacetExecutor.this.counts.v(), CountDateHistogramFacetExecutor.this.tzRounding);
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = CountDateHistogramFacetExecutor.this.indexFieldData.load(context).getLongValues();
        }

        public void collect(int doc) throws IOException {
            this.histoProc.onDoc(doc, this.values);
        }

        @Override
        public void postCollection() {
        }
    }
}

