package com.xebialabs.xltest.serialize;

import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONWriter;

import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.view.ListOfEvents;

//@Component
//@Provider
//@Produces({MediaType.APPLICATION_JSON})
public class ListOfEventsWriter extends BasicMessageBodyWriter<ListOfEvents> {

    @Override
    public final boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    protected void writeJson(final ListOfEvents events, final JSONWriter writer) throws JSONException {
        writer.array();
        for (Event event : events) {
            writeJson(event, writer);
        }
        writer.endArray();
    }

    protected void writeJson(final Event event, final JSONWriter writer) throws JSONException {
        map(writer, event.getProperties());
    }

    private void map(JSONWriter writer, Map<String, Object> properties) throws JSONException {
        writer.object();
        for (Map.Entry<String, Object> p : properties.entrySet()) {
            value(writer.key(p.getKey()), p.getValue());
        }
        writer.endObject();
    }

    private void list(final JSONWriter writer, final Collection<Object> collection) throws JSONException {
        writer.array();
        for (Object value : collection) {
            value(writer, value);
        }
        writer.endArray();
    }

    private void value(final JSONWriter writer, final Object value) throws JSONException {
        if (value instanceof Collection) {
            list(writer, (Collection) value);
        } else if (value instanceof Map) {
            map(writer, (Map<String, Object>) value);
        } else {
            writer.value(value);
        }

    }

    public String toJson(Event event) throws JSONException {
        StringWriter stringWriter = new StringWriter();
        JSONWriter writer = new JSONWriter(stringWriter);
        writeJson(event, writer);
        return stringWriter.toString();
    }

}
