package com.xebialabs.xltest.utils.glob;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.overthere.OverthereFile;

public class Globbit {
    private final static Logger LOG = LoggerFactory.getLogger(Globbit.class);

    public static Collection<OverthereFile> find(OverthereFile searchRoot, FileMatcher fileMatcher) {
        return matchingFiles(searchRoot, fileMatcher);
    }

    /**
     * Walks a directory structure depth-first and returns a flat list of all matches
     *
     * @param workingDirectoryOverthereFile Starting point of the directory walk
     * @param matcher                       {@link com.xebialabs.xltest.utils.glob.FileMatcher} used to select returned files
     * @return Flattened list of all matching descendents of file.
     */
    private static List<OverthereFile> matchingFiles(OverthereFile workingDirectoryOverthereFile, FileMatcher matcher) {
        List<OverthereFile> allFilesInWorkingDirectory = getPathTree(workingDirectoryOverthereFile);
        List<OverthereFile> matched = new ArrayList<>();

        String fileSeparator = workingDirectoryOverthereFile.getConnection().getHostOperatingSystem().getFileSeparator();
        String workingDirectory = workingDirectoryOverthereFile.getPath() + fileSeparator;

        for (OverthereFile file : allFilesInWorkingDirectory) {
            String path = file.getPath();
            int indexOf = path.indexOf(workingDirectory) + workingDirectory.length();
            String relativePath = path.substring(indexOf);
            String normalizedPath = relativePath.replace("\\", "/");

            if (matcher.match(normalizedPath)) {
                matched.add(file);
            }
        }

        return matched;
    }


    private static List<OverthereFile> getPathTree(OverthereFile file) {
        if (!file.isDirectory()) {
            return Collections.singletonList(file);
        } else {
            List<OverthereFile> result = new ArrayList<>();
            result.add(file);
            for (OverthereFile child : file.listFiles()) {
                result.addAll(getPathTree(child));
            }
            return result;
        }
    }
}
