/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class DocumentDictionary
implements Dictionary {
    protected final IndexReader reader;
    protected final String payloadField;
    protected final String contextsField;
    private final String field;
    private final String weightField;

    public DocumentDictionary(IndexReader reader, String field, String weightField) {
        this(reader, field, weightField, null);
    }

    public DocumentDictionary(IndexReader reader, String field, String weightField, String payloadField) {
        this(reader, field, weightField, payloadField, null);
    }

    public DocumentDictionary(IndexReader reader, String field, String weightField, String payloadField, String contextsField) {
        this.reader = reader;
        this.field = field;
        this.weightField = weightField;
        this.payloadField = payloadField;
        this.contextsField = contextsField;
    }

    @Override
    public InputIterator getEntryIterator() throws IOException {
        return new DocumentInputIterator(this.payloadField != null, this.contextsField != null);
    }

    protected class DocumentInputIterator
    implements InputIterator {
        private final int docCount;
        private final Set<String> relevantFields;
        private final boolean hasPayloads;
        private final boolean hasContexts;
        private final Bits liveDocs;
        private int currentDocId = -1;
        private long currentWeight;
        private BytesRef currentPayload;
        private Set<BytesRef> currentContexts;
        private final NumericDocValues weightValues;

        public DocumentInputIterator(boolean hasPayloads, boolean hasContexts) throws IOException {
            this.hasPayloads = hasPayloads;
            this.hasContexts = hasContexts;
            this.docCount = DocumentDictionary.this.reader.maxDoc() - 1;
            this.weightValues = DocumentDictionary.this.weightField != null ? MultiDocValues.getNumericValues((IndexReader)DocumentDictionary.this.reader, (String)DocumentDictionary.this.weightField) : null;
            this.liveDocs = DocumentDictionary.this.reader.leaves().size() > 0 ? MultiFields.getLiveDocs((IndexReader)DocumentDictionary.this.reader) : null;
            this.relevantFields = this.getRelevantFields(DocumentDictionary.this.field, DocumentDictionary.this.weightField, DocumentDictionary.this.payloadField, DocumentDictionary.this.contextsField);
        }

        @Override
        public long weight() {
            return this.currentWeight;
        }

        public Comparator<BytesRef> getComparator() {
            return null;
        }

        public BytesRef next() throws IOException {
            while (this.currentDocId < this.docCount) {
                IndexableField fieldVal;
                ++this.currentDocId;
                if (this.liveDocs != null && !this.liveDocs.get(this.currentDocId)) continue;
                Document doc = DocumentDictionary.this.reader.document(this.currentDocId, this.relevantFields);
                BytesRef tempPayload = null;
                BytesRef tempTerm = null;
                HashSet<BytesRef> tempContexts = new HashSet<BytesRef>();
                if (this.hasPayloads) {
                    IndexableField payload = doc.getField(DocumentDictionary.this.payloadField);
                    if (payload == null || payload.binaryValue() == null && payload.stringValue() == null) continue;
                    BytesRef bytesRef = tempPayload = payload.binaryValue() != null ? payload.binaryValue() : new BytesRef((CharSequence)payload.stringValue());
                }
                if (this.hasContexts) {
                    IndexableField[] contextFields;
                    for (IndexableField contextField : contextFields = doc.getFields(DocumentDictionary.this.contextsField)) {
                        if (contextField.binaryValue() == null && contextField.stringValue() == null) continue;
                        tempContexts.add(contextField.binaryValue() != null ? contextField.binaryValue() : new BytesRef((CharSequence)contextField.stringValue()));
                    }
                }
                if ((fieldVal = doc.getField(DocumentDictionary.this.field)) == null || fieldVal.binaryValue() == null && fieldVal.stringValue() == null) continue;
                tempTerm = fieldVal.stringValue() != null ? new BytesRef((CharSequence)fieldVal.stringValue()) : fieldVal.binaryValue();
                this.currentPayload = tempPayload;
                this.currentContexts = tempContexts;
                this.currentWeight = this.getWeight(doc, this.currentDocId);
                return tempTerm;
            }
            return null;
        }

        @Override
        public BytesRef payload() {
            return this.currentPayload;
        }

        @Override
        public boolean hasPayloads() {
            return this.hasPayloads;
        }

        protected long getWeight(Document doc, int docId) {
            IndexableField weight = doc.getField(DocumentDictionary.this.weightField);
            if (weight != null) {
                return weight.numericValue() != null ? weight.numericValue().longValue() : 0L;
            }
            if (this.weightValues != null) {
                return this.weightValues.get(docId);
            }
            return 0L;
        }

        private Set<String> getRelevantFields(String ... fields) {
            HashSet<String> relevantFields = new HashSet<String>();
            for (String relevantField : fields) {
                if (relevantField == null) continue;
                relevantFields.add(relevantField);
            }
            return relevantFields;
        }

        @Override
        public Set<BytesRef> contexts() {
            if (this.hasContexts) {
                return this.currentContexts;
            }
            return null;
        }

        @Override
        public boolean hasContexts() {
            return this.hasContexts;
        }
    }
}

