/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.instructions;

import fitnesse.slim.NameTranslator;
import fitnesse.slim.SlimError;
import fitnesse.slim.instructions.CallAndAssignInstruction;
import fitnesse.slim.instructions.CallInstruction;
import fitnesse.slim.instructions.ImportInstruction;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.InvalidInstruction;
import fitnesse.slim.instructions.MakeInstruction;
import java.util.List;

public class InstructionFactory {
    private InstructionFactory() {
    }

    public static Instruction createInstruction(List<Object> words, NameTranslator methodNameTranslator) {
        String id = InstructionFactory.getWord(words, 0);
        String operation = InstructionFactory.getWord(words, 1);
        Instruction instruction = "make".equalsIgnoreCase(operation) ? InstructionFactory.createMakeInstruction(id, words) : ("callAndAssign".equalsIgnoreCase(operation) ? InstructionFactory.createCallAndAssignInstruction(id, words, methodNameTranslator) : ("call".equalsIgnoreCase(operation) ? InstructionFactory.createCallInstruction(id, words, methodNameTranslator) : ("import".equalsIgnoreCase(operation) ? InstructionFactory.createImportInstruction(id, words) : InstructionFactory.createInvalidInstruction(id, operation))));
        return instruction;
    }

    private static MakeInstruction createMakeInstruction(String id, List<Object> words) {
        String instanceName = InstructionFactory.getWord(words, 2);
        String className = InstructionFactory.getWord(words, 3);
        Object[] args = InstructionFactory.makeArgsArray(words, 4);
        return new MakeInstruction(id, instanceName, className, args);
    }

    private static CallAndAssignInstruction createCallAndAssignInstruction(String id, List<Object> words, NameTranslator methodNameTranslator) {
        String symbolName = InstructionFactory.getWord(words, 2);
        String instanceName = InstructionFactory.getWord(words, 3);
        String methodName = InstructionFactory.getWord(words, 4);
        Object[] args = InstructionFactory.makeArgsArray(words, 5);
        return new CallAndAssignInstruction(id, symbolName, instanceName, methodName, args, methodNameTranslator);
    }

    private static CallInstruction createCallInstruction(String id, List<Object> words, NameTranslator methodNameTranslator) {
        String instanceName = InstructionFactory.getWord(words, 2);
        String methodName = InstructionFactory.getWord(words, 3);
        Object[] args = InstructionFactory.makeArgsArray(words, 4);
        return new CallInstruction(id, instanceName, methodName, args, methodNameTranslator);
    }

    private static ImportInstruction createImportInstruction(String id, List<Object> words) {
        String path = InstructionFactory.getWord(words, 2);
        return new ImportInstruction(id, path);
    }

    private static InvalidInstruction createInvalidInstruction(String id, String operation) {
        return new InvalidInstruction(id, operation);
    }

    private static String getWord(List<Object> words, int word) {
        try {
            return (String)words.get(word);
        }
        catch (Exception e) {
            throw new SlimError(String.format("message:<<%s %s.>>", "MALFORMED_INSTRUCTION", InstructionFactory.wordsToString(words)));
        }
    }

    private static Object[] makeArgsArray(List<Object> words, int argsIndex) {
        List<Object> argList = words.subList(argsIndex, words.size());
        Object[] args = argList.toArray(new Object[argList.size()]);
        return args;
    }

    private static String wordsToString(List<Object> words) {
        StringBuffer result = new StringBuffer();
        result.append("[");
        for (Object word : words) {
            result.append(word);
            result.append(",");
        }
        int end = result.length() - 1;
        if (result.charAt(end) == ',') {
            result.deleteCharAt(end);
        }
        result.append("]");
        return result.toString();
    }
}

