/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.io.IOException;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommands;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class RerouteExplanation
implements ToXContent {
    private AllocationCommand command;
    private Decision decisions;

    public RerouteExplanation(AllocationCommand command, Decision decisions) {
        this.command = command;
        this.decisions = decisions;
    }

    public AllocationCommand command() {
        return this.command;
    }

    public Decision decisions() {
        return this.decisions;
    }

    public static RerouteExplanation readFrom(StreamInput in) throws IOException {
        String commandName = in.readString();
        Object command = AllocationCommands.lookupFactorySafe(commandName).readFrom(in);
        Decision decisions = Decision.readFrom(in);
        return new RerouteExplanation((AllocationCommand)command, decisions);
    }

    public static void writeTo(RerouteExplanation explanation, StreamOutput out) throws IOException {
        out.writeString(explanation.command.name());
        AllocationCommands.lookupFactorySafe(explanation.command.name()).writeTo(explanation.command, out);
        Decision.writeTo(explanation.decisions, out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("command", this.command.name());
        AllocationCommands.lookupFactorySafe(this.command.name()).toXContent(this.command, builder, params, "parameters");
        if (this.decisions instanceof Decision.Multi) {
            this.decisions.toXContent(builder, params);
        } else {
            builder.startArray("decisions");
            this.decisions.toXContent(builder, params);
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }
}

