/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hppc;

import java.util.Arrays;
import org.elasticsearch.common.hppc.LongCollection;
import org.elasticsearch.common.hppc.LongLookupContainer;
import org.elasticsearch.common.hppc.cursors.LongCursor;
import org.elasticsearch.common.hppc.predicates.LongPredicate;

abstract class AbstractLongCollection
implements LongCollection {
    AbstractLongCollection() {
    }

    @Override
    public int removeAll(LongLookupContainer c) {
        final LongLookupContainer c2 = c;
        return this.removeAll(new LongPredicate(){

            @Override
            public boolean apply(long k) {
                return c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(LongLookupContainer c) {
        final LongLookupContainer c2 = c;
        return this.removeAll(new LongPredicate(){

            @Override
            public boolean apply(long k) {
                return !c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final LongPredicate predicate) {
        return this.removeAll(new LongPredicate(){

            @Override
            public boolean apply(long value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public long[] toArray() {
        int size = this.size();
        long[] array = new long[size];
        int i = 0;
        for (LongCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

