/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.packed.PagedMutable;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsBuilder;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractGeoPointIndexFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointCompressedAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.NonEstimatingEstimator;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;

public class GeoPointCompressedIndexFieldData
extends AbstractGeoPointIndexFieldData {
    private static final String PRECISION_KEY = "precision";
    private static final DistanceUnit.Distance DEFAULT_PRECISION_VALUE = new DistanceUnit.Distance(1.0, DistanceUnit.CENTIMETERS);
    private final CircuitBreakerService breakerService;
    private final GeoPointFieldMapper.Encoding encoding;

    public GeoPointCompressedIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, DistanceUnit.Distance precision, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.encoding = GeoPointFieldMapper.Encoding.of(precision);
        this.breakerService = breakerService;
    }

    /*
     * Loose catch block
     */
    @Override
    public AtomicGeoPointFieldData<ScriptDocValues> loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        AtomicGeoPointFieldData data = null;
        NonEstimatingEstimator estimator = new NonEstimatingEstimator(this.breakerService.getBreaker());
        if (terms == null) {
            data = new AbstractGeoPointIndexFieldData.Empty();
            estimator.afterLoad(null, data.ramBytesUsed());
            return data;
        }
        long initialSize = terms.size() >= 0L ? 1L + terms.size() : (long)(1 + Math.min(4096, reader.maxDoc()));
        int pageSize = Integer.highestOneBit(131072 / this.encoding.numBitsPerCoordinate() - 1) << 1;
        PagedMutable lat = new PagedMutable(initialSize, pageSize, this.encoding.numBitsPerCoordinate(), 0.0f);
        PagedMutable lon = new PagedMutable(initialSize, pageSize, this.encoding.numBitsPerCoordinate(), 0.0f);
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        boolean success = false;
        try {
            try (OrdinalsBuilder builder = new OrdinalsBuilder(terms.size(), reader.maxDoc(), acceptableTransientOverheadRatio);){
                GeoPoint point;
                AbstractGeoPointIndexFieldData.GeoPointEnum iter = new AbstractGeoPointIndexFieldData.GeoPointEnum(builder.buildFromTerms(terms.iterator(null)));
                while ((point = iter.next()) != null) {
                    long ord = builder.currentOrdinal();
                    if (lat.size() <= ord) {
                        long newSize = BigArrays.overSize(ord + 1L);
                        lat = (PagedMutable)lat.resize(newSize);
                        lon = (PagedMutable)lon.resize(newSize);
                    }
                    lat.set(ord, this.encoding.encodeCoordinate(point.getLat()));
                    lon.set(ord, this.encoding.encodeCoordinate(point.getLon()));
                }
                Ordinals build = builder.build(this.fieldDataType.getSettings());
                BytesValues.WithOrdinals ordinals = build.ordinals();
                if (ordinals.isMultiValued() || IndexFieldData.CommonSettings.getMemoryStorageHint(this.fieldDataType) == IndexFieldData.CommonSettings.MemoryStorageFormat.ORDINALS) {
                    if (lat.size() != ordinals.getMaxOrd()) {
                        lat = (PagedMutable)lat.resize(ordinals.getMaxOrd());
                        lon = (PagedMutable)lon.resize(ordinals.getMaxOrd());
                    }
                    data = new GeoPointCompressedAtomicFieldData.WithOrdinals(this.encoding, lon, lat, build);
                } else {
                    int maxDoc = reader.maxDoc();
                    PagedMutable sLat = new PagedMutable((long)reader.maxDoc(), pageSize, this.encoding.numBitsPerCoordinate(), 0.0f);
                    PagedMutable sLon = new PagedMutable((long)reader.maxDoc(), pageSize, this.encoding.numBitsPerCoordinate(), 0.0f);
                    long missing = this.encoding.encodeCoordinate(0.0);
                    for (int i = 0; i < maxDoc; ++i) {
                        long nativeOrdinal = ordinals.getOrd(i);
                        if (nativeOrdinal != -1L) {
                            sLat.set((long)i, lat.get(nativeOrdinal));
                            sLon.set((long)i, lon.get(nativeOrdinal));
                            continue;
                        }
                        sLat.set((long)i, missing);
                        sLon.set((long)i, missing);
                    }
                    FixedBitSet set = builder.buildDocsWithValuesSet();
                    data = set == null ? new GeoPointCompressedAtomicFieldData.Single(this.encoding, sLon, sLat) : new GeoPointCompressedAtomicFieldData.SingleFixedSet(this.encoding, sLon, sLat, set);
                }
                success = true;
                AtomicGeoPointFieldData atomicGeoPointFieldData = data;
                return atomicGeoPointFieldData;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (success) {
                estimator.afterLoad(null, data.ramBytesUsed());
            }
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService, GlobalOrdinalsBuilder globalOrdinalBuilder) {
            FieldDataType type = mapper.fieldDataType();
            String precisionAsString = type.getSettings().get(GeoPointCompressedIndexFieldData.PRECISION_KEY);
            DistanceUnit.Distance precision = precisionAsString != null ? DistanceUnit.Distance.parseDistance(precisionAsString) : DEFAULT_PRECISION_VALUE;
            return new GeoPointCompressedIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, precision, breakerService);
        }
    }
}

