/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.settings;

import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.cluster.settings.Validator;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.index.settings.IndexDynamicSettings;

public class IndexDynamicSettingsModule
extends AbstractModule {
    private final DynamicSettings indexDynamicSettings = new DynamicSettings();

    public IndexDynamicSettingsModule() {
        this.indexDynamicSettings.addDynamicSetting("index.store.throttle.max_bytes_per_sec", Validator.BYTES_SIZE);
        this.indexDynamicSettings.addDynamicSetting("index.store.throttle.type");
        this.indexDynamicSettings.addDynamicSetting("index.routing.allocation.require.*");
        this.indexDynamicSettings.addDynamicSetting("index.routing.allocation.include.*");
        this.indexDynamicSettings.addDynamicSetting("index.routing.allocation.exclude.*");
        this.indexDynamicSettings.addDynamicSetting("index.routing.allocation.enable");
        this.indexDynamicSettings.addDynamicSetting("index.routing.allocation.disable_allocation");
        this.indexDynamicSettings.addDynamicSetting("index.routing.allocation.disable_new_allocation");
        this.indexDynamicSettings.addDynamicSetting("index.routing.allocation.disable_replica_allocation");
        this.indexDynamicSettings.addDynamicSetting("index.translog.fs.type");
        this.indexDynamicSettings.addDynamicSetting("index.number_of_replicas", Validator.NON_NEGATIVE_INTEGER);
        this.indexDynamicSettings.addDynamicSetting("index.auto_expand_replicas");
        this.indexDynamicSettings.addDynamicSetting("index.blocks.read_only");
        this.indexDynamicSettings.addDynamicSetting("index.blocks.read");
        this.indexDynamicSettings.addDynamicSetting("index.blocks.write");
        this.indexDynamicSettings.addDynamicSetting("index.blocks.metadata");
        this.indexDynamicSettings.addDynamicSetting("index.ttl.disable_purge");
        this.indexDynamicSettings.addDynamicSetting("index.refresh_interval", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.recovery.initial_shards");
        this.indexDynamicSettings.addDynamicSetting("index.merge.policy.min_merge_size", Validator.BYTES_SIZE);
        this.indexDynamicSettings.addDynamicSetting("index.merge.policy.max_merge_size", Validator.BYTES_SIZE);
        this.indexDynamicSettings.addDynamicSetting("index.merge.policy.max_merge_docs", Validator.POSITIVE_INTEGER);
        this.indexDynamicSettings.addDynamicSetting("index.merge.policy.merge_factor", Validator.INTEGER_GTE_2);
        this.indexDynamicSettings.addDynamicSetting("index.compound_format");
        this.indexDynamicSettings.addDynamicSetting("index.merge.policy.min_merge_docs", Validator.POSITIVE_INTEGER);
        this.indexDynamicSettings.addDynamicSetting("index.merge.policy.max_merge_docs", Validator.POSITIVE_INTEGER);
        this.indexDynamicSettings.addDynamicSetting("index.merge.policy.merge_factor", Validator.INTEGER_GTE_2);
        this.indexDynamicSettings.addDynamicSetting("index.compound_format");
        this.indexDynamicSettings.addDynamicSetting("index.index_concurrency", Validator.NON_NEGATIVE_INTEGER);
        this.indexDynamicSettings.addDynamicSetting("index.compound_on_flush", Validator.BOOLEAN);
        this.indexDynamicSettings.addDynamicSetting("index.codec.bloom.load", Validator.BOOLEAN);
        this.indexDynamicSettings.addDynamicSetting("index.gc_deletes", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.codec");
        this.indexDynamicSettings.addDynamicSetting("index.fail_on_merge_failure");
        this.indexDynamicSettings.addDynamicSetting("index.fail_on_corruption");
        this.indexDynamicSettings.addDynamicSetting("index.indexing.slowlog.threshold.index.warn", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.indexing.slowlog.threshold.index.info", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.indexing.slowlog.threshold.index.debug", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.indexing.slowlog.threshold.index.trace", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.indexing.slowlog.reformat");
        this.indexDynamicSettings.addDynamicSetting("index.indexing.slowlog.level");
        this.indexDynamicSettings.addDynamicSetting("index.search.slowlog.threshold.query.warn", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.search.slowlog.threshold.query.info", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.search.slowlog.threshold.query.debug", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.search.slowlog.threshold.query.trace", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.search.slowlog.threshold.fetch.warn", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.search.slowlog.threshold.fetch.info", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.search.slowlog.threshold.fetch.debug", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.search.slowlog.threshold.fetch.trace", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.search.slowlog.reformat");
        this.indexDynamicSettings.addDynamicSetting("index.search.slowlog.level");
        this.indexDynamicSettings.addDynamicSetting("index.routing.allocation.total_shards_per_node", Validator.INTEGER);
        this.indexDynamicSettings.addDynamicSetting("index.merge.policy.expunge_deletes_allowed", Validator.DOUBLE);
        this.indexDynamicSettings.addDynamicSetting("index.merge.policy.floor_segment", Validator.BYTES_SIZE);
        this.indexDynamicSettings.addDynamicSetting("index.merge.policy.max_merge_at_once", Validator.INTEGER_GTE_2);
        this.indexDynamicSettings.addDynamicSetting("index.merge.policy.max_merge_at_once_explicit", Validator.INTEGER_GTE_2);
        this.indexDynamicSettings.addDynamicSetting("index.merge.policy.max_merged_segment", Validator.BYTES_SIZE);
        this.indexDynamicSettings.addDynamicSetting("index.merge.policy.segments_per_tier", Validator.DOUBLE_GTE_2);
        this.indexDynamicSettings.addDynamicSetting("index.merge.policy.reclaim_deletes_weight", Validator.NON_NEGATIVE_DOUBLE);
        this.indexDynamicSettings.addDynamicSetting("index.compound_format");
        this.indexDynamicSettings.addDynamicSetting("index.translog.interval", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.translog.flush_threshold_ops", Validator.INTEGER);
        this.indexDynamicSettings.addDynamicSetting("index.translog.flush_threshold_size", Validator.BYTES_SIZE);
        this.indexDynamicSettings.addDynamicSetting("index.translog.flush_threshold_period", Validator.TIME);
        this.indexDynamicSettings.addDynamicSetting("index.translog.disable_flush");
        this.indexDynamicSettings.addDynamicSetting("index.warmer.enabled");
    }

    public void addDynamicSettings(String ... settings) {
        this.indexDynamicSettings.addDynamicSettings(settings);
    }

    public void addDynamicSetting(String setting, Validator validator) {
        this.indexDynamicSettings.addDynamicSetting(setting, validator);
    }

    @Override
    protected void configure() {
        this.bind(DynamicSettings.class).annotatedWith(IndexDynamicSettings.class).toInstance(this.indexDynamicSettings);
    }
}

