/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.fielddata.breaker;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.breaker.MemoryCircuitBreaker;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;
import org.elasticsearch.indices.fielddata.breaker.FieldDataBreakerStats;
import org.elasticsearch.node.settings.NodeSettingsService;

public class InternalCircuitBreakerService
extends AbstractLifecycleComponent<InternalCircuitBreakerService>
implements CircuitBreakerService {
    public static final String CIRCUIT_BREAKER_MAX_BYTES_SETTING = "indices.fielddata.breaker.limit";
    public static final String CIRCUIT_BREAKER_OVERHEAD_SETTING = "indices.fielddata.breaker.overhead";
    public static final double DEFAULT_OVERHEAD_CONSTANT = 1.03;
    private static final String DEFAULT_BREAKER_LIMIT = "60%";
    private volatile MemoryCircuitBreaker breaker;
    private volatile long maxBytes;
    private volatile double overhead;

    @Inject
    public InternalCircuitBreakerService(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        this.maxBytes = settings.getAsMemory(CIRCUIT_BREAKER_MAX_BYTES_SETTING, DEFAULT_BREAKER_LIMIT).bytes();
        this.overhead = settings.getAsDouble(CIRCUIT_BREAKER_OVERHEAD_SETTING, (Double)1.03);
        this.breaker = new MemoryCircuitBreaker(new ByteSizeValue(this.maxBytes), this.overhead, null, this.logger);
        nodeSettingsService.addListener(new ApplySettings());
    }

    @Override
    public MemoryCircuitBreaker getBreaker() {
        return this.breaker;
    }

    public synchronized void resetBreaker() {
        MemoryCircuitBreaker oldBreaker = this.breaker;
        this.breaker = new MemoryCircuitBreaker(new ByteSizeValue(this.maxBytes), this.overhead, oldBreaker, this.logger);
    }

    @Override
    public FieldDataBreakerStats stats() {
        return new FieldDataBreakerStats(this.breaker.getMaximum(), this.breaker.getUsed(), this.breaker.getOverhead(), this.breaker.getTrippedCount());
    }

    @Override
    protected void doStart() throws ElasticsearchException {
    }

    @Override
    protected void doStop() throws ElasticsearchException {
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            double newOverhead;
            long newMaxByteSizeValue = settings.getAsMemory(InternalCircuitBreakerService.CIRCUIT_BREAKER_MAX_BYTES_SETTING, Long.toString(InternalCircuitBreakerService.this.maxBytes)).bytes();
            boolean breakerResetNeeded = false;
            if (newMaxByteSizeValue != InternalCircuitBreakerService.this.maxBytes) {
                InternalCircuitBreakerService.this.logger.info("updating [{}] from [{}]({}) to [{}]({})", InternalCircuitBreakerService.CIRCUIT_BREAKER_MAX_BYTES_SETTING, InternalCircuitBreakerService.this.maxBytes, new ByteSizeValue(InternalCircuitBreakerService.this.maxBytes), newMaxByteSizeValue, new ByteSizeValue(newMaxByteSizeValue));
                InternalCircuitBreakerService.this.maxBytes = newMaxByteSizeValue;
                breakerResetNeeded = true;
            }
            if ((newOverhead = settings.getAsDouble(InternalCircuitBreakerService.CIRCUIT_BREAKER_OVERHEAD_SETTING, (Double)InternalCircuitBreakerService.this.overhead).doubleValue()) != InternalCircuitBreakerService.this.overhead) {
                InternalCircuitBreakerService.this.logger.info("updating [{}] from [{}] to [{}]", InternalCircuitBreakerService.CIRCUIT_BREAKER_OVERHEAD_SETTING, InternalCircuitBreakerService.this.overhead, newOverhead);
                InternalCircuitBreakerService.this.overhead = newOverhead;
                breakerResetNeeded = true;
            }
            if (breakerResetNeeded) {
                InternalCircuitBreakerService.this.resetBreaker();
            }
        }
    }
}

