'use strict';angular.module('XLTest',['ngRoute','ngSanitize','restangular','xl.templates','xl.components','LocalStorageModule','XLPlatform.metadata','XLTest.authentication','XLTest.dipHandler','XLPlatform.sse','XLPlatform.filters','XLTest.security','XLTest.testspecifications','XLTest.hosts','XLTest.testruns','XLTest.reports','XLTest.dashboards','XLTest.navbar','XLTest.directives','XLTest.directives.multiselector','XLTest.service.hosts','XLTest.service']).value('REPORT_REF_BASE','/reports/').config(function($routeProvider,RestangularProvider,$httpProvider){RestangularProvider.setBaseUrl('');RestangularProvider.setRequestInterceptor(function(elem,operation){if(operation==='remove'){return null;}
return elem;});RestangularProvider.setEncodeIds(false);Highcharts.setOptions({global:{useUTC:false},chart:{animation:false,style:{'fontFamily':'OpenSans, Helvetica, Arial, sans-serif','fontSize':'12px',color:'#333333'}},credits:{enabled:false},legend:{itemStyle:{fontWeight:'normal',color:'#333333'}},plotOptions:{line:{animation:false}},colors:['#9ADA7F','#FD8D10','#055F75','#E36C16','#009190'],lang:{numericSymbols:null}});var interceptor=['$rootScope','$q','$location','Base64',function(scope,$q,$location,Base64){function success(response){return response;}
function error(response){var status=response.status;if(status===401){$location.path('/login');}
return $q.reject(response);}
return function(promise){return promise.then(success,error);};}];$httpProvider.responseInterceptors.push(interceptor);$routeProvider.when('/login',{controller:'LoginController',templateUrl:'public/login.html'}).when('/welcome',{templateUrl:'partials/welcome.html',controller:'Welcome'}).when('/getstarted',{templateUrl:'partials/testspecwizard.html',controller:'TestSpecWizard'}).when('/import/:resultLocation',{templateUrl:'partials/import.html',controller:'Import'}).when('/dashboards',{templateUrl:'partials/dashboards.html',controller:'Dashboards'}).when('/dashboards/new',{templateUrl:'partials/editdashboard.html',controller:'EditDashboard'}).when('/dashboards/:dashboardId',{templateUrl:'partials/editdashboard.html',controller:'EditDashboard'}).when('/hosts',{templateUrl:'partials/hosts.html',controller:'Hosts'}).when('/hosts/new',{templateUrl:'partials/edithost.html',controller:'EditHost'}).when('/hosts/:hostId',{templateUrl:'partials/edithost.html',controller:'EditHost'}).when('/testruns',{templateUrl:'partials/testruns.html',controller:'TestRuns'}).when('/testruns/:testRunId',{templateUrl:'partials/testrunprogress.html',controller:'TestRunProgress'}).when('/reports/:testRunId/:reportId*',{templateUrl:'partials/openreport.html',controller:'OpenReport'}).when('/testspecifications/:testSpecificationId/dashboard',{templateUrl:'partials/renderdashboard.html',controller:'RenderDashboard'}).when('/testspecifications/:testSpecificationId/report/:reportId',{templateUrl:'partials/renderreport.html',controller:'RenderReport'}).when('/testspecifications',{templateUrl:'partials/testspecifications.html',controller:'TestSpecifications'}).when('/testspecifications/new',{templateUrl:'partials/newtestspecification.html',controller:'NewTestSpecification'}).when('/testspecifications/:testSpecificationId',{templateUrl:'partials/edittestspecification.html',controller:'EditTestSpecification'}).when('/reports',{templateUrl:'partials/reports.html',controller:'Reports'}).when('/reports/new',{templateUrl:'partials/editreport.html',controller:'EditReport'}).when('/reports/:reportId',{templateUrl:'partials/editreport.html',controller:'EditReport'}).when('/editor/:testRunId',{templateUrl:'partials/reporteditor.html',controller:'ReportEditor'}).otherwise({redirectTo:'/welcome'});});'use strict';angular.module('XLPlatform.filters',[]).filter('duration',function(){return function(milliseconds){if(!milliseconds){return'0 ms';}
var seconds=Math.floor(milliseconds/1000);var minutes=Math.floor(seconds/60);var hours=Math.floor(minutes/60);minutes=minutes%60;seconds=seconds%60;milliseconds=milliseconds%1000;return(hours>0?(hours+'h '):'')+
(minutes>0?(minutes+'m '):'')+
(seconds>0?(seconds+'s '):'')+
milliseconds+'ms';};}).filter('testRunDuration',function(){return function(endDate,startDate){if(!startDate){return'Not started?';}
if(!endDate){return'In progress';}
var end=Date.parse(endDate);var start=Date.parse(startDate);var milliseconds=end-start;var seconds=Math.floor(milliseconds/1000);var minutes=Math.floor(seconds/60);var hours=Math.floor(minutes/60);minutes=minutes%60;seconds=seconds%60;return(hours<10?'0':'')+hours+':'+
(minutes<10?'0':'')+minutes+':'+
(seconds<10?'0':'')+seconds;};}).filter('ciname',function(){return function(id){if(!id){return'';}
var parts=id.split('/');return parts[parts.length-1];};});'use strict';angular.module('XLPlatform.metadata',['restangular']).factory('metaDataService',function(Restangular){return Restangular.all('metadata/type');}).factory('dataService',function(Restangular){return Restangular.all('data');}).directive('xlListOfString',function(){return{restrict:'A',require:'ngModel',link:function(scope,element,attrs,ngModel){ngModel.$formatters.push(function(value){return value?_(value).join(', '):'';});ngModel.$parsers.push(function(value){return value?_.map(value.split(','),function(s){return s.trim();}):[];});}};}).directive('xlCi',function(dataService){return{restrict:'A',require:'ngModel',template:'<select ng-model="ngModel" ng-required="type.required" class="form-control" id="{{id}}" ng-options="def.id as def.id for def in cis"></select>',scope:{id:'@',type:'=',ngModel:'='},link:function(scope,element,attrs,ngModel){dataService.getList({'type':scope.type.referencedType}).then(function(cis){scope.cis=cis;},function(){scope.cis=[];});}};}).directive('xlListOfCi',function(dataService){return{restrict:'A',template:'<p class="form-control" ng-repeat="ci in ngModel track by $index">'+'<span class="tag-label" ng-bind="ci"></span>'+'<span class="options"><a class="remove-icon" ng-click="remove($index)"></a></span>'+'</p>'+'<select class="form-control" ng-model="newEntry" id="{{id}}" ng-options="def.id as def.id for def in cis"></select>',require:'ngModel',scope:{id:'@',type:'=',ngModel:'='},link:function(scope,element,attrs,ngModel){var unique=attrs.unique==='true';scope.remove=function(index){scope.ngModel=scope.ngModel.slice(0,index).concat(scope.ngModel.slice(index+1));};scope.$watch('newEntry',function(){if(!scope.ngModel){scope.ngModel=[];}
if(scope.newEntry&&!(unique&&_.contains(scope.ngModel,scope.newEntry))){scope.ngModel.push(scope.newEntry);}
delete scope.newEntry;});dataService.getList({'type':scope.type.referencedType}).then(function(cis){scope.cis=cis;},function(){scope.cis=[];});}};}).directive('xlMapStringString',function(dataService){return{restrict:'A',template:'<p class="form-control" ng-repeat="(key, value) in ngModel">'+'<span class="tag-label">{{key}}: {{value}}</span>'+'<span class="options"><a class="remove-icon" ng-click="remove(key)"></a></span>'+'</p>'+'<p>'+'<input type="text" class="form-control" style="display: inline; width:50%; border-right: none" ng-model="newKey" id="{{id}}" placeholder="enter a new key..."/>'+'<input type="text" class="form-control" style="display: inline; width:50%; border-left: none" ng-model="newValue" placeholder="... and its value"/>'+'</p>',require:'ngModel',scope:{id:'@',ngModel:'='},link:function(scope,element,attrs,ngModel){scope.remove=function(key){delete scope.ngModel[key];};var inputs=element.find('input');inputs.on('keypress',function(event){if(event.keyCode===13){console.log('Enter key',scope.newKey,scope.newValue);if(scope.newKey&&scope.newValue){if(!scope.ngModel){scope.ngModel={};}
scope.ngModel[scope.newKey]=scope.newValue;delete scope.newKey;delete scope.newValue;inputs[0].focus();}
event.preventDefault();scope.$digest();}})}};}).directive('dip',function(metaDataService){return{restrict:'E',templateUrl:'partials/dip.html',scope:{type:'@',model:'='},link:function(scope,element,attrs){var currentType=scope.selectedType;scope.prefix=attrs.prefix||'dip';var sticky=(attrs.sticky||'').split(',');scope.propertyFilter=function(p){return!p.hidden;};metaDataService.getList().then(function(metadata){var type=scope.type;scope.ciTypes=_.filter(metadata,function(metadatum){return(metadatum.type===type||_.contains(metadatum.extends,type))&&!metadatum.virtual;});if(scope.model&&scope.model.type){scope.selectedType=_.where(scope.ciTypes,{type:scope.model.type})[0];}},function(){console.log('unable to fetch metadata');});scope.$watch('model',function(){if(scope.model&&scope.model.type){scope.selectedType=_.where(scope.ciTypes,{type:scope.model.type})[0];}});scope.$watch('selectedType',function(){if(currentType&&scope.model.type){_(currentType.properties).forEach(function(p){if(!_.contains(sticky,p.name)){delete scope.model[p.name];}});}
currentType=scope.selectedType;if(scope.selectedType){scope.model.type=scope.selectedType.type;_(scope.selectedType.properties).forEach(function(p){if(!scope.model[p.name]&&p.defaultValue){scope.model[p.name]=p.defaultValue;}});}});}};});'use strict';angular.module('XLPlatform.sse',[]).directive('serverSentEvents',function(){return{restrict:'A',scope:{closeCallback:'&close'},link:function(scope,element,attr){var source=attr.source;var eventType=attr.eventType||'event';var eventSource=new EventSource(source);eventSource.addEventListener(eventType,function(event){var data=angular.fromJson(event.data);console.log('Have a new event: ',data);var ts=new Date(data.timestamp).toLocaleTimeString();var type=data.type;element.append(ts+': '+type+' -> '+event.data+'<br/>');scrollToBottom();},false);eventSource.addEventListener('close',function(event){console.log('closing event source');eventSource.close();var data=event.data&&angular.fromJson(event.data);scope.closeCallback({data:data});scope.$digest();scrollToBottom();},false);function scrollToBottom(){var scrollMe=angular.element('body');scrollMe.scrollTop(scrollMe.prop('scrollHeight'));}}};});'use strict';angular.module('XLTest.directives',[]).value('REPORT_REF_BASE','/').directive('presentationMode',['$location','$window','$timeout',function(location,window,timeout){return{restrict:'E',transclude:true,scope:{mode:'=?'},templateUrl:'partials/presentation-mode.html',link:function($scope){$scope.mode=$scope.mode||false;function disablePresentationModeHandler(event){timeout(function(){if($scope.mode&&event.keyCode===27){$scope.mode=false;}});}
angular.element(window).bind('keyup',disablePresentationModeHandler);$scope.mode=location.hash()==='presentation';$scope.togglePresentationMode=function(){$scope.mode=!$scope.mode;};$scope.$watch('mode',function(){location.hash($scope.mode?'presentation':'');});}};}]).directive('highchart',function($location,REPORT_REF_BASE){return{restrict:'E',template:'<div></div>',scope:{config:'=',thechart:'=?'},replace:true,link:function(scope,element){scope.$watch('config',function(){var chartConfig=_.clone(scope.config,true);chartConfig.title=undefined;if(scope.config.chart&&scope.config.chart.events){chartConfig.chart.events=_.mapValues(scope.config.chart.events,function(val,key){if(key==='click'){return function(){$location.path(val);scope.$apply();};}});if(!chartConfig.plotOptions){chartConfig.plotOptions={};}
if(!chartConfig.plotOptions.series){chartConfig.plotOptions.series={};}
if(!chartConfig.plotOptions.series.events){chartConfig.plotOptions.series.events=chartConfig.chart.events;}}else if(scope.config.plotOptions&&scope.config.plotOptions.series&&scope.config.plotOptions.series.point&&scope.config.plotOptions.series.point.events){chartConfig.plotOptions.series.point.events=_.mapValues(scope.config.plotOptions.series.point.events,function(val,key){if(val==='url'){return function(){var params=this.options.params;var url=this.options.url;if(params&&url){$location.path(REPORT_REF_BASE+url).search(params);}else if(params){$location.search(params);}else if(url){$location.path(REPORT_REF_BASE+url);}
scope.$apply();};}else{return function(){alert(key+': '+this.options.y);};}});}
element.highcharts(chartConfig);scope.thechart=element.highcharts();});}};}).directive('flakinessSummary',function($location){return{restrict:'E',templateUrl:'partials/flakiness-summary.html',scope:{data:'='},replace:true,link:function(scope){scope.rows=scope.data.tests;scope.toReport=function(){var params=scope.data.params[0];var url=scope.data.url;$location.path(url).search(params);};},controller:function(){}};}).directive('reportRef',function(){return{restrict:'A',template:'<ng-include src="pageTemplate"></ng-include>',scope:{ref:'=reportRef'},controller:function($scope,$location,$window,Restangular){var queryParams=$location.search();$scope.startDate=new Date(Date.now()-1000*60*60*24*14);$scope.endDate=new Date();function getParameterByName(url,name){var match=new RegExp('[?&]'+name+'=([^&]*)').exec(url);return match&&decodeURIComponent(match[1].replace(/\+/g,' '));}
$scope.$watch('startDate',function(newVal,oldVal){if(newVal!==oldVal&&oldVal!==undefined){fetchReport(newVal,$scope.endDate);}},true);$scope.$watch('endDate',function(newVal,oldVal){if(newVal!==oldVal&&oldVal!==undefined){fetchReport($scope.startDate,newVal);}},true);$scope.$watch('ref',function(){if(!$scope.ref){return;}
$scope.pageTemplate='';var queryParamStartDate=getParameterByName($scope.ref,'startDate')||queryParams.startDate;var queryParamEndDate=getParameterByName($scope.ref,'endDate')||queryParams.endDate;var startDate,endDate;if(queryParamStartDate&&queryParamEndDate){startDate=new Date(parseInt(queryParamStartDate));endDate=new Date(parseInt(queryParamEndDate));}
fetchReport(startDate,endDate);});$scope.loadMoreRecords=function(){var testsToShow=queryParams.testsToShow;if(!testsToShow){testsToShow=10;}
testsToShow+=10;queryParams.testsToShow=testsToShow;fetchReport();};if(!$scope.ref){$scope.pageTemplate='reports/noreport.html';}
function fetchReport(startDate,endDate){var url=$scope.ref;var fixedUrl=url;if(url.indexOf('?')>0){fixedUrl=url.substring(0,url.indexOf('?'));}
if(startDate&&endDate){queryParams.startDate=startDate.getTime();queryParams.endDate=endDate.getTime();}
Restangular.one('reports').customGET(fixedUrl,queryParams).then(function(response){if(!response){$scope.pageTemplate='reports/noreport.html';}
$scope.pageTemplate='reports/'+response.type+'.html';$scope.report=response.report;},function(response){console.log('Error in report response:',response);if(response.status!==404){alert('Failed to retrieve report on '+$scope.ref);}});}}};}).directive('innerHtml',function(){return{restrict:'A',scope:{html:'=innerHtml'},link:function(scope,element){scope.$watch('html',function(){element.html(scope.html);});}};}).directive('closeable',function(){return{restrict:'A',link:function(scope,element){var closeButton=angular.element('<span class="icon-x"></span>');element.prepend(closeButton);closeButton.click(function(){element.addClass('ng-hide');});}};}).directive('affix',function(){return{$scope:true,link:function($scope,$element){var relativeTo=angular.element(window.document.getElementsByTagName('main')),win=relativeTo,relativeToOffset=null,fixedAt=null;$scope.affixed=false;$scope.offset=0;win.bind('scroll',checkPosition);win.bind('resize',function(){$scope.$apply(function(){$scope.affixed=false;});relativeToOffset=null;fixedAt=null;checkPosition();});function checkPosition(){relativeToOffset=relativeToOffset||win[0].offsetTop;fixedAt=fixedAt||$element[0].offsetTop-relativeToOffset;$scope.$apply(function(){$scope.offset={top:relativeToOffset+'px'};$scope.affixed=fixedAt<=relativeTo[0].scrollTop;});console.log('update',$scope.offset,$scope.affixed);}}};}).directive('grid',function($window,$timeout){var ROWS=12;var GridList=$window.GridList;if(!$window.GridList){throw new Error('GridList lib required');}
return{restrict:'A',scope:{items:'=grid',presentationMode:'=presentationMode'},templateUrl:'partials/grid.html',link:function(scope,element){function calculateCellSize(){scope.cellHeight=element.height()/ROWS;scope.cellWidth=element.width()/ROWS;}
function disablePresentationModeHandler(event){$timeout(function(){if(scope.presentationMode&&event.keyCode===27){scope.presentationMode=false;}});}
function resizeHandler(){scope.$apply(calculateCellSize);}
angular.element($window).bind('resize',resizeHandler).bind('keyup',disablePresentationModeHandler);scope.$on('$destroy',function(){angular.element($window).unbind('resize',resizeHandler).unbind('keyup',disablePresentationModeHandler);});scope.$watch('presentationMode',function(){$timeout(calculateCellSize,10);});scope.edit=function(){};scope.done=function(){};},controller:function($scope,$element){var grid,inDrag=false,_items,_previousDragPosition,$positionHighlight=$element.find('.position-highlight').hide();$scope.$watch('items',function(){if($scope.items&&!inDrag){var items=_.map($scope.items,function(item){return{id:item.id,x:item.x,y:item.y,w:item.w,h:item.h};});grid=new GridList(items,{rows:ROWS});}});this.startDnd=function(){inDrag=true;_items=grid.cloneItems();};this.dragDnd=function(item,position){var newPosition=snapItemPositionToGrid(item,position);if(dragPositionChanged(newPosition)){_previousDragPosition=newPosition;grid.cloneItems(_items);grid.moveItemToPosition(item,newPosition);updateScopeItems();$positionHighlight.css({width:item.w*$scope.cellWidth,height:item.h*$scope.cellHeight,left:item.x*$scope.cellWidth,top:item.y*$scope.cellHeight}).show();}};this.stopDnd=function(){_previousDragPosition=null;$positionHighlight.hide();updateScopeItems();inDrag=false;};function dragPositionChanged(position){if(!_previousDragPosition){return true;}
return(position[0]!==_previousDragPosition[0]||position[1]!==_previousDragPosition[1]);}
function snapItemPositionToGrid(item,position){var row,col;col=position.left;row=position.top;col=Math.max(col,0);row=Math.max(row,0);col=Math.min(col,grid.cols());row=Math.min(row,ROWS-item.h);return[col,row];}
function updateScopeItems(){function findScopeItem(id){return _.find($scope.items,function(i){return i.id===id;});}
var items=grid.cloneItems();for(var i=0;i<items.length;i++){var item=items[i];var scopeItem=findScopeItem(item.id);scopeItem.x=item.x;scopeItem.y=item.y;scopeItem.w=item.w;scopeItem.h=item.h;}}}};}).directive('gridPane',function(){return{restrict:'A',require:'^grid',link:function(scope,element,attr,gridCtrl){function toGridPosition(position){return{left:Math.round(position.left/scope.cellWidth),top:Math.round(position.top/scope.cellHeight)};}
element.draggable({zIndex:2,scroll:false,containment:'parent'});function updatePosition(){element.css({width:scope.item.w*scope.cellWidth,height:scope.item.h*scope.cellHeight,left:scope.item.x*scope.cellWidth,top:scope.item.y*scope.cellHeight});}
scope.$watch('item.x',updatePosition);scope.$watch('item.y',updatePosition);scope.$watch('item.w',updatePosition);scope.$watch('item.h',updatePosition);scope.$watch('cellWidth',updatePosition);scope.$watch('cellWidth',updatePosition);element.on('dragstart',function(){scope.$apply(function(){gridCtrl.startDnd(scope.item);});});element.on('drag',function(){scope.$apply(function(){gridCtrl.dragDnd(scope.item,toGridPosition(element.position()));});});element.on('dragstop',function(){scope.$apply(function(){element.removeClass('ui-draggable-dragging');gridCtrl.stopDnd(scope.item);updatePosition();});});}};}).directive('trendIndicator',function(){return{restrict:'A',transclude:true,scope:{trendIndicator:'='},template:'<div ng-class="{\'icon-arrow-down\': trendIndicator === \'-\', \'icon-arrow-up\': trendIndicator === \'+\'}">'};}).directive('sprite',function(){return{restrict:'E',scope:{img:'@',spriteClass:'@'},link:function(scope,element){scope.$watch('img',function(){element.html('<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="icon-'+
scope.img+
(scope.spriteClass?(' '+scope.spriteClass):'')+'"><use xlink:href="images/sprite.svg#'+scope.img+'"></use></svg>');});}};}).directive('faqPanel',function(){return{restrict:'E',templateUrl:'/partials/faq-panel.html'};}).directive('breadcrumb',function($location){return{restrict:'E',template:'<ol class="breadcrumb"><li ng-repeat="crumb in crumbs"><sprite sprite-class="breadcrumb-arrow" img="arrow-breadcrumb" ng-show="!$first"></sprite><a href="{{crumb.href}}">{{crumb.name}}</a></li></ol>',link:function(scope){function getParameterByName(url,name){var match=new RegExp('[?&]'+name+'=([^&]*)').exec(url);return match&&decodeURIComponent(match[1].replace(/\+/g,' '));}
scope.crumbs=[];var queryParams=$location.search();var prefixes=queryParams.prefix?queryParams.prefix.split(';'):[];prefixes=_.filter(prefixes,function(prefixString){return prefixString.length>0;});var url=decodeURIComponent($location.path());var fixedUrl=url;if(url.indexOf('?')>0){fixedUrl=url.substring(0,url.indexOf('?'));}
var queryParamStartDate=getParameterByName(url,'startDate')||queryParams.startDate;var queryParamEndDate=getParameterByName(url,'endDate')||queryParams.endDate;var concattedPrefixes='';_.each(prefixes,function(element){concattedPrefixes=concattedPrefixes+element;var newUrl='#'+fixedUrl+'?startDate='+queryParamStartDate+'&endDate='+queryParamEndDate+'&prefix='+concattedPrefixes+';';scope.crumbs.push({href:newUrl,name:element});concattedPrefixes+=';';});}};});'use strict';angular.module('XLTest.directives.multiselector',[]).directive('multiSelector',function(){return{restrict:'EA',templateUrl:'partials/multiselector.html',require:'^ngModel',scope:{available:'=',selected:'=ngModel',edited:'='},controller:function($scope){var updateMultiSelector=function(){var hasEditedItemAsChild=function(s){if($scope.edited){if(s.name===$scope.edited){return true;}else if(s.testSpecifications){for(var i=0;i<s.testSpecifications.length;i++){if(hasEditedItemAsChild(s.testSpecifications[i])){return true;}}}}
return false;};var availableNames=_.map($scope.available,function(e){return e.name;});var selectedNames=_.map($scope.selected,function(e){return e.name;});availableNames=_.difference(availableNames,selectedNames);$scope.availableSubset=_.filter($scope.available,function(e){return _.contains(availableNames,e.name)&&!hasEditedItemAsChild(e);});};$scope.$watch('available',updateMultiSelector);$scope.$watch('selected',updateMultiSelector);$scope.$watch('edited',updateMultiSelector);$scope.selectedItems=[];$scope.selectItem=function(item,event){if(!(event.shiftKey||event.ctrlKey||event.metaKey)){$scope.selectedItems=[];}
if(!$scope.isSelected(item)){$scope.selectedItems.push(item);}};$scope.removeItem=function(item){$scope.selected=_.without($scope.selected,item);};$scope.isSelected=function(item){return _.contains($scope.selectedItems,item);};$scope.addToSuperSet=function(){if(!$scope.selectedItems){return;}
if(!$scope.selected){$scope.selected=[];}
$scope.selected=$scope.selected.concat($scope.selectedItems);$scope.selectedItems=[];updateMultiSelector();};}};});'use strict';angular.module('XLTest.security',['restangular']).controller('LoginController',['$scope','$rootScope','$location','AuthenticationService',function($scope,$rootScope,$location,AuthenticationService){$scope.login=function(){$scope.dataLoading=true;AuthenticationService.login($scope.username,$scope.password,function(response){if(response.success){AuthenticationService.setCredentials($scope.username,$scope.password);$rootScope.$broadcast('loggedIn',response.username);$location.path('/welcome');}else{$scope.error=response.message;$scope.dataLoading=false;}});};}]).controller('Security',['$scope','$rootScope','$location','AuthenticationService',function($scope,$rootScope,$location,AuthenticationService){if(AuthenticationService.isUserLoggedIn()){$scope.userName=AuthenticationService.loggedInUser();}
$scope.$on('loggedIn',function(event,username){$scope.userName=username;});$scope.logout=function(){AuthenticationService.logout(function(response){$scope.userName=null;$location.path('/login');});};}]);'use strict';angular.module('XLTest.testruns',['restangular']).factory('testRunsService',function(Restangular){return Restangular.all('test');}).controller('TestRuns',function($scope,testRunsService,Restangular,cinameFilter){testRunsService.getList().then(function(testRuns){$scope.testRuns=testRuns;},function(){$scope.testRuns=[];});$scope.fetchReports=function(testRun){var testRunId=cinameFilter(testRun.id);Restangular.one('reports',testRunId).get().then(function(response){testRun.reports=response;},function(response){if(response.status!==404){alert('Failed to retrieve report');}});};}).controller('TestRunProgress',function($scope,$routeParams,testRunsService,Restangular){console.log('testRunProgress');$scope.testRunId=$routeParams.testRunId;$scope.testRunUrl='/test/'+$routeParams.testRunId;Restangular.one('reports',$routeParams.testRunId).get().then(function(response){$scope.reports=response;},function(response){if(response.status!==404){alert('Failed to retrieve report');}});$scope.done=false;$scope.isDone=function(data){console.log('isDone: ',data);$scope.done=true;$scope.finalReport='../test/'+$routeParams.testRunId;$scope.$digest();};$scope.stopTestRun=function(){console.log('Stop test run ',$routeParams.testRunId);testRunsService.all($scope.testRunId).post({type:'STOP'});};});'use strict';angular.module('XLTest.dipHandler',['restangular']).factory('dipHandlers',function(Restangular){function ciHandler(referencedType,term){var a=Restangular.all('data').getList({'type':referencedType}).then(function(cis){return _.map(cis,function(ci){return{'id':ci.id,'type':ci.type};});},function(){return[];});return a;}
function ciFormHandler(metadata,options){return ciHandler(metadata.referencedType,options.term);}
return{formHandlers:{CI:{addCandidates:ciFormHandler},SET_OF_CI:{addCandidates:ciFormHandler},LIST_OF_CI:{addCandidates:ciFormHandler}},ciHandler:ciHandler};});'use strict';angular.module('XLTest.testspecifications',['restangular','XLTest.service','XLTest.service.hosts']).factory('dataService',function(Restangular){return Restangular.all('data');}).controller('TestSpecifications',function($scope,$location,dataService,Restangular,$xlModal,dipHandlers){var searchUsagesAsChild=function(testSpecName,testSpecifications){var usages=[];for(var i=0;i<testSpecifications.length;i++){var testSpecification=testSpecifications[i];var children=testSpecification.testSpecifications;if(children){for(var j=0;j<children.length;j++){if(children[j].name===testSpecName){usages.push(testSpecification);}else{if(children[j].testSpecifications){var usagesInChildren=searchUsagesAsChild(testSpecName,children[j].testSpecifications);usages=usages.concat(usagesInChildren);}}}}}
return usages;};Restangular.all('testspecifications').getList().then(function(testSpecifications){$scope.testSpecifications=testSpecifications;},function(){$scope.testSpecifications=[];});$scope.toggleNode=function(testSpecification){testSpecification.show=!testSpecification.show;};$scope.removeTestSpecificationReference=function(testSpecification){Restangular.one('testspecifications',testSpecification.name+'/'+testSpecification.parent).remove().then(function(){Restangular.all('testspecifications').getList().then(function(testSpecifications){$scope.testSpecifications=testSpecifications;},function(){$scope.testSpecifications=[];});},function(){alert('Oops. Failed to delete TestSpecification '+testSpecification.name+' from parent '+testSpecification.parent);});$location.path('/testspecifications');};$scope.removeTestSpecification=function(testSpecification,testSpecifications){var xlModalInstanceForRemove=$xlModal.open({templateUrl:'remove-testspecification-modal.html',windowClass:'warning-deletion-modal',controller:function($scope,$xlModalInstance){$scope.modalTitle='Are you sure that you want to delete the "'+testSpecification.name+'" test specification?';$scope.items=searchUsagesAsChild(testSpecification.name,testSpecifications);if($scope.items.length===0){$scope.modalDescription='';}else{$scope.modalDescription='If you press "Delete" the test specification will also be removed from the following Super Sets:';}
$scope.testSpecifications=testSpecifications;$scope.cancel=function(){$xlModalInstance.dismiss('cancel');};$scope.delete=function(){$xlModalInstance.close(testSpecification);};$xlModalInstance.handlers={};$xlModalInstance.handlers.onEscModal=function(){$xlModalInstance.dismiss('esc');};$xlModalInstance.handlers.onCloseModal=function(){$xlModalInstance.dismiss('close');};}});xlModalInstanceForRemove.result.then(function(testSpecification){Restangular.one('testspecifications',testSpecification.name).remove().then(function(){Restangular.all('testspecifications').getList().then(function(testSpecifications){$scope.testSpecifications=testSpecifications;},function(){$scope.testSpecifications=[];});},function(){alert('Oops. Failed to delete TestSpecification '+testSpecification.name);});$location.path('/testspecifications');});};$scope.executeTestSpec=function(testSpecification){Restangular.one('execute',testSpecification.name).post().then(function(task){alert('Now running task with id: '+task.taskId);$location.path('/testspecifications');},function(response){if(response.status===422){console.log('422:',response);Restangular.all('metadata').customGET('type/generic.ExecutableTestSpecification').then(function(metadata){console.log(metadata);$scope.testSpecificationMetaData=metadata;});var xlModalInstance=$xlModal.open({templateUrl:'execute-modal.html',windowClass:'execute-modal',controller:function($scope,$xlModalInstance){$scope.formHandlers=dipHandlers.formHandlers;$scope.props={};$scope.parameters=response.data.parameters;$scope.props.commandLine=response.data.commandLine;$scope.props.host=response.data.hostId;$scope.missingProperties=!($scope.props.host&&$scope.props.commandLine);$scope.formatValues=function(vals){var uniqVals=_.uniq(_.map(vals,function(e){if(e){return e;}else{return'<none>';}}));return uniqVals.length===1?'':'multiple values: '+uniqVals;};$scope.execute=function(){$xlModalInstance.close({commandLine:$scope.props.commandLine,hostId:$scope.props.host&&$scope.props.host.id,parameters:_.reduce($scope.parameters,function(acc,item){acc[item.name]=item.value;return acc;},{})});};$scope.toEditPage=function(){$xlModalInstance.dismiss('edit');};$scope.cancel=function(){$xlModalInstance.dismiss('cancel');};$xlModalInstance.handlers={};$xlModalInstance.handlers.onEscModal=function(){$xlModalInstance.dismiss('esc');};$xlModalInstance.handlers.onCloseModal=function(){$xlModalInstance.dismiss('close');};}});xlModalInstance.result.then(function(parameters){Restangular.one('execute',testSpecification.name).customPOST(parameters).then(function(task){alert('Now running task with id: '+task.taskId);},function(response){console.log('Error:',response);alert('Something went wrong. Check the console.');});},function(reason){if('edit'===reason){$location.path('/testspecifications/'+testSpecification.name).search('type',testSpecification.type);}});}});};$scope.selectReport=function(testSpecification){var xlModalInstance=$xlModal.open({templateUrl:'open-report-modal.html',windowClass:'open-report-modal',controller:function($scope,$xlModalInstance){Restangular.all('data').getList({'type':'generic.Report'}).then(function(reports){$scope.items=_.filter(reports,function(report){return(report.applicableTools.length===0)||_.contains(report.applicableTools,testSpecification.testToolName);});},function(){$scope.items=[];});$scope.go=function(item){$xlModalInstance.close(item);};$xlModalInstance.handlers={};$xlModalInstance.handlers.onEscModal=function(){$xlModalInstance.dismiss('esc');};$xlModalInstance.handlers.onCloseModal=function(){$xlModalInstance.dismiss('close');};}});xlModalInstance.result.then(function(item){var location='/testspecifications/'+testSpecification.name+'/report/'+item.id.substring(item.id.lastIndexOf('/')+1);$location.path(location);});};}).controller('NewTestSpecification',function($scope,$location,$routeParams,$xlModal,dataService,cinameFilter,Restangular,dipHandlers){$scope.testSpecification={};$scope.singleOrSet='singleTestSpec';$scope.allowTestSpecTypeChange=false;$scope.testSpecificationType=$location.search().type;$scope.ciTypes=[];$scope.formHandlers=dipHandlers.formHandlers;Restangular.all('metadata/type').getList().then(function(metadata){var type='generic.TestSpecification';var ciTypes=_.filter(metadata,function(metadatum){return(metadatum.type===type||_.contains(metadatum.extends,type))&&!metadatum.virtual&&(metadatum.name!=='ShowCaseTestSpecification');});$scope.ciTypes=ciTypes;if($routeParams.testSpecificationId){var testSpecificationType=$location.search().type;$scope.showTestSpecForm(testSpecificationType,$routeParams.testSpecificationId);}},function(){console.log('unable to test specification types');});$scope.loadTypeSpecificationMetadata=function(singleOrSetVal){if(singleOrSetVal==='testSpecSet'){$scope.testSpecificationType='TestSpecificationSet';Restangular.all('testspecifications').getList().then(function(testSpecifications){$scope.testSpecifications=testSpecifications;},function(){$scope.testSpecifications=[];});Restangular.all('metadata').customGET('type/generic.'+$scope.testSpecificationType).then(function(metadata){$scope.testSpecificationMetaData=metadata;$scope.testSpecification={type:'generic.TestSpecificationSet',testSpecifications:[]};});}else{$scope.testSpecification={};}};$scope.showTestSpecForm=function(type){if(type){Restangular.all('metadata').customGET('type/'+type).then(function(metadata){Restangular.all('testtools').getList().then(function(testTools){var testToolNames=[];testTools.forEach(function(each){testToolNames.push(each.name);});var testToolProperty=_.find(metadata.properties,function(property){return property.name==='testToolName';});testToolProperty.kind='ENUM';testToolProperty.enumValues=testToolNames;$scope.testSpecificationMetaData=metadata;});});}};$scope.add=function(){var newTestSpec=_.cloneDeep($scope.testSpecification);newTestSpec.id='Configuration/TestSpecifications/'+$scope.testSpecification.name;delete newTestSpec.name;if($scope.singleOrSet==='testSpecSet'){newTestSpec.testSpecifications=_.map(newTestSpec.testSpecifications,function(e){return'Configuration/TestSpecifications/'+e.name;});}else{newTestSpec.type=$scope.testSpecificationType;}
console.log('newTestSpec:'+newTestSpec);dataService.post(newTestSpec).then(function(){console.log('test specification created',$scope.testSpecification.id);$location.path('/testspecifications');},function(response){console.log('There was an error saving',response);alert('Unable to save test specification');});};$scope.cancel=function(){$location.path('/testspecifications');};}).controller('EditTestSpecification',function($scope,$location,$routeParams,dataService,cinameFilter,Restangular,dipHandlers,jsonHttp){$scope.formHandlers=dipHandlers.formHandlers;dataService.get('Configuration/TestSpecifications/'+$routeParams.testSpecificationId).then(function(testSpecification){$scope.testSpecification=testSpecification;Restangular.all('metadata').customGET('type/'+$scope.testSpecification.type).then(function(metadata){if(metadata.type==='generic.TestSpecificationSet'||_.contains(metadata.extends,'generic.TestSpecificationSet')){$scope.singleOrSet='testSpecSet';$scope.testSpecificationMetaData=metadata;Restangular.all('testspecifications').getList().then(function(testSpecifications){$scope.testSpecifications=testSpecifications;$scope.testSpecification.testSpecifications=_.map($scope.testSpecification.testSpecifications,function(e){return _.where(testSpecifications,{name:cinameFilter(e)})[0];});},function(){$scope.testSpecifications=[];});}else{$scope.singleOrSet='singleTestSpec';Restangular.all('testtools').getList().then(function(testTools){var testToolProperty=_.find(metadata.properties,function(property){return property.name==='testToolName';});console.log("Test tool property",testToolProperty);testToolProperty.kind='ENUM';testToolProperty.enumValues=_.map(testTools,function(t){return t.name;});$scope.testSpecificationMetaData=metadata;});}});},function(response){console.log('Unable to load test specification',response);});$scope.add=function(){var ci=$scope.testSpecification.plain();if($scope.singleOrSet==='testSpecSet'){ci.testSpecifications=_.map(ci.testSpecifications,function(e){return'Configuration/TestSpecifications/'+e.name;});}
console.log('persisting CI',ci);jsonHttp.put('/data/'+ci.id,ci,null,$scope.testSpecificationMetaData).then(function(){console.log('test specification updated');$location.path('/testspecifications');});};$scope.cancel=function(){$location.path('/testspecifications');};}).controller('Welcome',function($scope){$scope.welcome='welcome';}).controller('TestSpecWizard',function($scope,$location,Restangular,$q,toHost,eventular){function WizardSteps(stepDef,formData){var self=this;var currentStep=stepDef[stepDef.initial];var previousSteps=[];self.id=stepDef.initial;self.data=formData||{};function transitionTo(newState){$scope.errorMessage=undefined;if(currentStep.transition){self.inTransition=true;currentStep.transition(self.data).then(function(){newState(self.data);self.inTransition=undefined;},function(reason){console.log('Canceling transition: '+reason);$scope.errorMessage=reason;self.inTransition=undefined;});}else{newState(self.data);}}
function goToStep(next){if(next){var nextStep=stepDef[next];if(nextStep){previousSteps.push([self.id,currentStep]);currentStep=nextStep;self.id=next;}else{alert('Invalid state in wizard. No step named "'+next+'".');}}}
this.next=function(){transitionTo(function(){var next=currentStep.next;if(typeof next==='function'){goToStep(currentStep.next(self.data));}else{goToStep(next);}});};this.hasNext=function(){return currentStep.hasOwnProperty('next');};this.previous=function(){var previous=previousSteps.pop();self.id=previous[0];currentStep=previous[1];$scope.errorMessage=undefined;};this.hasPrevious=function(){return previousSteps.length>0;};this.finish=function(){transitionTo(currentStep.finish);};this.hasFinish=function(){return currentStep.hasOwnProperty('finish');};}
$scope.cancel=function(){$location.path('/dashboard');};$scope.anySelected=function(map){return _.filter(_.values(map)).length===0;};Restangular.all('testtools').getList().then(function(testTools){$scope.testTools=testTools;});$scope.step=new WizardSteps({initial:'step1','step1':{next:function(data){data.pattern=_.find($scope.testTools,{'name':data.testTool}).pattern;$scope.hasPattern=data.pattern!==null;return'step2';}},'step2':{next:'step3',transition:function(data){var deferred=$q.defer();var host=toHost(data);host.path=data.path;host.pattern=data.pattern;host.testTool=data.testTool;Restangular.all('testtools').customGET(data.testTool+'/paths',host).then(function(response){$scope.importPaths=response.paths;data.testSpecifications=response.testSpecifications;deferred.resolve();},function(response){console.log('error is',response);deferred.reject(response.data.error+'.');});return deferred.promise;}},'step3':{next:'step4',transition:function(data){var deferred=$q.defer();$scope.existingTestSpecification=undefined;if(data.testSpecifications.length>0){$scope.existingTestSpecification=data.testSpecifications[0];data.name=data.testSpecifications[0];}
deferred.resolve();return deferred.promise;}},'step4':{next:function(data){eventular('/import/'+data.name).then(function(e){console.log('success',e);$scope.percentage=100;$scope.total=e.total;$scope.done=true;},function(e){console.log('failure',e);},function(e){console.log('notify',e);$scope.percentage=e.percentage;});return'step5';},transition:function(data){var deferred=$q.defer();var host=toHost(data);if(!host){alert('Not implemented: protocol='+data.protocol);return;}
$scope.creationMessage=undefined;if($scope.existingTestSpecification!==data.name){Restangular.all('data').post({id:'Configuration/TestSpecifications/'+data.name,type:'generic.ExecutableTestSpecification',testToolName:data.testTool,host:host,workingDirectory:data.path,searchPattern:data.pattern}).then(function(){deferred.resolve();},function(response){if(response.status===409){deferred.reject('A specification named '+data.name+' already exists. Please provide a different name.');}else{console.log('There was an error saving',response);deferred.reject('Unable to save your configuration. (status code: '+response.status+')');}});}else{deferred.resolve();}
return deferred.promise;}},'step5':{finish:function(data){$location.path('/testspecifications');}}});}).factory('eventular',function($q){return function(source,eventType,closeSourceEventType){var eventSource=new EventSource(source);var deferred=$q.defer();eventType=eventType||'event';closeSourceEventType=closeSourceEventType||'close';eventSource.addEventListener(eventType,function(e){console.log('eventular message',e);var data=e.data&&angular.fromJson(e.data);deferred.notify(data);},false);eventSource.addEventListener(closeSourceEventType,function(e){console.log('eventular message',e);var data=e.data&&angular.fromJson(e.data);eventSource.close();if(data&&data.error){deferred.reject(data);}else{deferred.resolve(data);}},false);eventSource.onerror=function(e){console.log('eventular error',e.message,e.error,e);eventSource.close();deferred.reject(e);};return deferred.promise;};});'use strict';angular.module('XLTest.hosts',['restangular','XLTest.service']).factory('hostsService',function(Restangular){return Restangular.all('data');}).controller('Hosts',function($scope,$location,Restangular){Restangular.all('hosts').getList().then(function(hosts){$scope.hosts=hosts;},function(){$scope.hosts=[];});$scope.toggleNode=function(host){host.show=!host.show;};}).controller('EditHost',function($scope,$location,$routeParams,dataService,hostsService,cinameFilter,Restangular,dipHandlers,jsonHttp){$scope.host={};$scope.inEditMode=false;if($routeParams.hostId){hostsService.get('Infrastructure/'+$routeParams.hostId).then(function(host){$scope.host=host;$scope.name=cinameFilter(host.id);$scope.inEditMode=true;});}
$scope.add=function(){if($scope.inEditMode){Restangular.all('metadata').customGET('type/'+$scope.host.type).then(function(metadata){var ci=$scope.host.plain();jsonHttp.put('/data/'+ci.id,ci,null,metadata).then(function(){console.log('host updated');$location.path('/hosts');});});}else{var newHost=$scope.host;newHost.id='Infrastructure/'+$scope.name;console.log('newHost:'+newHost);hostsService.post(newHost).then(function(){console.log('host created',newHost.id);$location.path('/hosts');},function(){console.log('There was an error saving');});}};});'use strict';angular.module('XLTest.reports',['restangular']).factory('reportsService',function(Restangular){return Restangular.all('data');}).controller('Reports',function($scope,$location,reportsService){reportsService.getList({'type':'generic.Report'}).then(function(reports){$scope.reports=reports;},function(){$scope.reports=[];});reportsService.getList({'type':'generic.Qualification'}).then(function(qualifications){$scope.qualifications=qualifications;},function(){$scope.qualifications=[];});$scope.remove=function(report){report.remove().then(function(){$scope.reports=_.without($scope.reports,report);});};}).controller('EditReport',function($scope,$location,$routeParams,reportsService,cinameFilter){$scope.report={};$scope.inEditMode=false;$scope.type=$routeParams.type;if($routeParams.reportId){reportsService.get('Configuration/Reports/'+$routeParams.reportId).then(function(report){$scope.report=report;$scope.name=cinameFilter(report.id);$scope.inEditMode=true;});}
$scope.add=function(){if($scope.inEditMode){$scope.report.put();$location.path('/reports');}else{reportsService.post($scope.report).then(function(){console.log('Object saved OK');$location.path('/reports');},function(){console.log('There was an error saving');});}};}).controller('OpenReport',function($scope,$routeParams,cinameFilter){var testRunId=$routeParams.testRunId;var reportId=$routeParams.reportId;$scope.checkAllFlag=true;$scope.subsuites=[];$scope.$watch('report',function(){if($scope.report){var reportSubsuites=$scope.report.subsuites;var subsuites=_.map(reportSubsuites,function(el){return{'name':el,'checked':true};});$scope.subsuites=subsuites;}});$scope.toggleSuiteOnHighChart=function(name,showItem){var chart=$scope.thechart;var re=new RegExp(';'+name+'$');var item=_.find(chart.series,function(serie){return re.test(serie.name);});if(showItem===undefined){showItem=!item.visible;}
if(showItem){item.show();return true;}
item.hide();return false;};$scope.toggleSeries=function(name){$scope.toggleSuiteOnHighChart(name);};$scope.toggleCheckAllWhenNeeded=function(){var uncheckedSubsuiteFound=_.find($scope.subsuites,function(subsuite){return!subsuite.checked;});$scope.checkAllFlag=(uncheckedSubsuiteFound===undefined);};$scope.checkAll=function(){var newCheckAllFlag=$scope.checkAllFlag;_.forEach($scope.subsuites,function(el){$scope.toggleSuiteOnHighChart(el.name,newCheckAllFlag);var subsuite=_.find($scope.subsuites,function(subsuite){return subsuite.name===el.name;});subsuite.checked=newCheckAllFlag;});$scope.toggleCheckAllWhenNeeded();};$scope.myStartDate=new Date();$scope.myEndDate=new Date();$scope.reportUrl=cinameFilter(testRunId)+"/"+reportId;}).controller('RenderReport',function($scope,$routeParams,cinameFilter,Restangular){var testSpecificationId=$routeParams.testSpecificationId;var reportId=$routeParams.reportId;$scope.itemUrl=reportId+'/testspecification/'+testSpecificationId;}).controller('ReportEditor',function($scope,$routeParams,Restangular){$scope.script='resultHolder.setResult("<h1>Hello world</h1>")';$scope.reportType='html';$scope.run=function(){var reportObject={id:'',type:'generic.Report',script:$scope.script,reportType:$scope.reportType};Restangular.one('reports').customPOST(reportObject,$routeParams.testRunId).then(function(response){console.log('Report output is: ',response);$scope.pageTemplate='reports/'+response.type+'.html';$scope.report=response.report;},function(response){console.log('Error in report response:',response);});};});'use strict';angular.module('XLTest.dashboards',['restangular']).factory('dashboardsService',function(Restangular){return Restangular.all('data');}).controller('RenderDashboard',function($scope,$location,$routeParams,$window,$route,Restangular){$scope.testSpecification={};$scope.inEditMode=false;function loadDashboard(){Restangular.one('testspecifications',$routeParams.testSpecificationId).customGET('/dashboard',{'runId':$routeParams.runId,'_':Date.now()}).then(function(response){$scope.dashboard=response;},function(response){console.log('error is',response);});}
loadDashboard();$scope.presentationMode=$location.hash()==='presentation';$scope.togglePresentationMode=function(){$scope.presentationMode=!$scope.presentationMode;};$scope.$watch('presentationMode',function(){$location.hash($scope.presentationMode?'presentation':'');});$scope.$watch(function(scope){if(scope.dashboard){var map=_.map(scope.dashboard.reportHolders,function(rh){return{x:rh.x,y:rh.y,w:rh.w,h:rh.h,id:rh.id};});return map;}},function(newVals,oldVals){_.forEach(newVals,function(item){var oldItem=_.find(oldVals,{'id':item.id});if(oldItem&&(oldItem.x!==item.x||oldItem.y!==item.y||oldItem.w!==item.w||oldItem.h!==item.h)){var reportHolder=_.find($scope.dashboard.reportHolders,{'id':item.id});Restangular.all('data').customPUT(reportHolder,reportHolder.id);}});},true);$scope.addReport=function(){var reportHolderId=$scope.dashboard.id+'/'+Date.now();var reportHolder={type:'generic.ReportHolder',id:reportHolderId,x:0,y:0,w:4,h:4,report:'Configuration/Reports/Bar'};Restangular.all('data').customPOST(reportHolder).then(function(){console.log('Updating dashboard');var dashboard=Restangular.copy($scope.dashboard);dashboard.reportHolders.push(reportHolder);Restangular.all('data').customPUT(dashboard,dashboard.id).then(function(){loadDashboard();});});};$scope.edit=function(item){console.log('edit',arguments);$scope.w=item.w;$scope.h=item.h;item.editing=true;};$scope.done=function(item,newW,newH){console.log('done',item,newW,newH);item.w=newW;item.h=newH;delete item.editing;$timeout(function(){grid.gridList('resizeItem',item);angular.element($window).triggerHandler('resize');},10);};}).controller('Dashboards',function($scope,$location,dashboardsService){dashboardsService.getList({'type':'generic.Dashboard'}).then(function(dashboards){$scope.dashboards=dashboards;},function(){$scope.dashboards=[];});$scope.remove=function(dashboard){dashboard.remove().then(function(){$scope.dashboards=_.without($scope.dashboards,dashboard);});};}).controller('EditDashboard',function($scope,$location,$routeParams,dashboardsService,cinameFilter){$scope.dashboard={};$scope.inEditMode=false;if($routeParams.dashboardId){dashboardsService.get('Configuration/Dashboards/'+$routeParams.dashboardId).then(function(dashboard){$scope.dashboard=dashboard;$scope.name=cinameFilter(dashboard.id);$scope.inEditMode=true;});}
$scope.add=function(){if($scope.inEditMode){$scope.dashboard.put();$location.path('/dashboards');}else{dashboardsService.post($scope.dashboard).then(function(){console.log('Object saved OK');$location.path('/dashboards');},function(){console.log('There was an error saving');});}};});'use strict';angular.module('XLTest.navbar',[]).controller('NavBar',function($scope,$location){function toggle(path){$scope.inTestSpecifications=$scope.inHosts=$scope.inTestRuns=$scope.inReports=$scope.inDashboards=$scope.inImports=false;if(/dashboard/.test(path)){$scope.inDashboards=true;}else if(/^\/testspecifications/.test(path)){$scope.inTestSpecifications=true;}else if(/^\/hosts/.test(path)){$scope.inHosts=true;}else if(/^\/testruns/.test(path)){$scope.inTestRuns=true;}else if(/^\/reports/.test(path)){$scope.inReports=true;}else if(/^\/dashboards/.test(path)){$scope.inDashboards=true;}else if(/^\/getstarted/.test(path)){$scope.inImports=true;}
console.log('Path did not match:',path);}
$scope.$on('$routeChangeStart',function(){toggle($location.path());});toggle($location.path());});'use strict';angular.module('XLTest.service',[]).factory('jsonHttp',function($http,$q){var successWrapper=function(result){return result.data;};var errorWrapper=function(error){return $q.reject(error.data||error.message);};var mergeConfigs=function(c1,c2){return c2?angular.extend(c1,c2):c1;};return{'get':function(url,config){var defaults={'headers':{'Accept':'application/json'}};return $http.get(url,mergeConfigs(defaults,config)).then(successWrapper,errorWrapper);},'post':function(url,data,config){var defaults={'headers':{'Accept':'application/json','Content-Type':'application/json'}};return $http.post(url,data||'',mergeConfigs(defaults,config)).then(successWrapper,errorWrapper);},'put':function(url,data,config,metadata){var properties=metadata.properties;properties.forEach(function(property){if(property.kind==='CI'){var ciProp=data[property.name];if(ciProp){data[property.name]=ciProp.id;}}});var defaults={'headers':{'Accept':'application/json','Content-Type':'application/json'}};return $http.put(url,data||'',mergeConfigs(defaults,config)).then(successWrapper,errorWrapper);}};});'use strict';angular.module('XLTest.service.hosts',[]).factory('toHost',function(){return function(data){var host;if(data.protocol==='local'){host={id:'Infrastructure/'+data.name+' Host',type:'overthere.LocalHost'};}else if(data.protocol==='ssh'){host={id:'Infrastructure/'+data.name+' Host',type:'overthere.SshHost',address:data.ssh_host,username:data.ssh_username,password:data.ssh_password,os:'UNIX'};}else if(data.protocol==='cifs'){host={id:'Infrastructure/'+data.name+' Host',type:'overthere.CifsHost',address:data.cifs_host,username:data.cifs_username,password:data.cifs_password,os:'WINDOWS'};}else if(data.protocol==='jenkins'){host={id:'Infrastructure/'+data.name+' Host',type:'overthere.JenkinsHost',address:data.jenkins_host,jobName:data.jenkins_jobName,username:data.jenkins_username,password:data.jenkins_password,os:'UNIX'};}
return host;};}).directive('hostForm',function(){return{restrict:'E',require:'ngModel',scope:{data:'=ngModel'},templateUrl:'partials/hostform.html',link:function($scope){$scope.data.protocol=$scope.data.protocol||'local';$scope.data.ssh_connectionType=$scope.data.ssh_connectionType||'SFTP';}};});'use strict';angular.module('XLTest.authentication',[]).factory('AuthenticationService',['Base64','$http','$rootScope','localStorageService',function(Base64,$http,$rootScope,localStorageService){var service={};var userInfo;if(localStorageService.get('userInfo')){userInfo=localStorageService.get('userInfo');$http.defaults.headers.common.Authorization=userInfo.token;}
service.login=function(username,password,callback){var auth=Base64.encode(username+':'+password);$http.get('/login',{headers:{'Authorization':'Basic '+auth}}).success(function(data,status){var success={'success':true,'username':username};callback(success);}).error(function(data,status){if(status===401){var failure={'success':false,'message':'The username or password you have entered is incorrect.'};callback(failure);}});};service.logout=function(callback){$http.get('/login/logout').success(function(data,status){service.clearCredentials();callback();});};service.isUserLoggedIn=function(){return!!userInfo;};service.loggedInUser=function(){return userInfo.username;};service.setCredentials=function(username,password){var authdata=Base64.encode(username+':'+password);$http.defaults.headers.common.Authorization='Basic '+authdata;userInfo={username:username,token:'Basic '+authdata};localStorageService.set('userInfo',userInfo);};service.clearCredentials=function(){localStorageService.clearAll();userInfo=undefined;$http.defaults.headers.common.Authorization='';};return service;}]).factory('Base64',function(){var keyStr='ABCDEFGHIJKLMNOP'+'QRSTUVWXYZabcdef'+'ghijklmnopqrstuv'+'wxyz0123456789+/'+'=';return{getBasicAuthorization:function(username,password){return'Basic '+this.encode(username+':'+password);},encode:function(input){var output="";var chr1,chr2,chr3="";var enc1,enc2,enc3,enc4="";var i=0;do{chr1=input.charCodeAt(i++);chr2=input.charCodeAt(i++);chr3=input.charCodeAt(i++);enc1=chr1>>2;enc2=((chr1&3)<<4)|(chr2>>4);enc3=((chr2&15)<<2)|(chr3>>6);enc4=chr3&63;if(isNaN(chr2)){enc3=enc4=64;}else if(isNaN(chr3)){enc4=64;}
output=output+
keyStr.charAt(enc1)+
keyStr.charAt(enc2)+
keyStr.charAt(enc3)+
keyStr.charAt(enc4);chr1=chr2=chr3="";enc1=enc2=enc3=enc4="";}while(i<input.length);return output;}};});