/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.TestTool;
import com.xebialabs.xltest.repository.HostRepository;
import com.xebialabs.xltest.repository.TestTools;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import java.util.Collection;

public class TestResultLocator {
    private final TestTools testTools;
    private Host host;
    private TestTool testTool;

    public TestResultLocator(TestTools testTools) {
        this.testTools = testTools;
    }

    public TestResultLocator forHost(String type, String address, String username, String password, String jobName) {
        this.host = HostRepository.create(type, address, username, password, jobName);
        return this;
    }

    public TestResultLocator forTestTool(String testToolName) {
        this.testTool = this.testTools.findByName(testToolName);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OverthereFile> locate(String baseDir, String pattern) {
        try (OverthereConnection connection = this.host.getConnection();){
            Collection<OverthereFile> collection = this.testTool.findTestResultPaths(connection.getFile(baseDir), new FileMatcher(pattern));
            return collection;
        }
    }

    public Host getHost() {
        return this.host;
    }
}

