/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.util.Iterator;

public final class GeohashPathIterator
implements Iterator<String> {
    private final String geohash;
    private int currentLength;

    public GeohashPathIterator(String geohash) {
        this.geohash = geohash;
        this.currentLength = geohash.length();
    }

    @Override
    public boolean hasNext() {
        return this.currentLength > 0;
    }

    @Override
    public String next() {
        String result = this.geohash.substring(0, this.currentLength);
        --this.currentLength;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("unable to remove a geohash from this path");
    }
}

