/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mustache.util;

import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.CountDownLatch;
import org.elasticsearch.common.mustache.MustacheException;

public class LatchedWriter
extends Writer {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final StringBuilder buffer = new StringBuilder();
    private final Writer writer;
    private volatile Throwable e;

    public LatchedWriter(Writer writer) {
        this.writer = writer;
    }

    public synchronized void done() throws IOException {
        this.writer.append(this.buffer);
        this.latch.countDown();
    }

    public void failed(Throwable e) {
        this.e = e;
        this.latch.countDown();
    }

    @Override
    public synchronized void write(char[] cbuf, int off, int len) throws IOException {
        this.checkException();
        if (this.latch.getCount() == 0L) {
            this.writer.write(cbuf, off, len);
        } else {
            this.buffer.append(cbuf, off, len);
        }
    }

    private void checkException() throws IOException {
        if (this.e != null) {
            if (this.e instanceof IOException) {
                throw (IOException)this.e;
            }
            throw new IOException(this.e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        this.checkException();
        if (this.latch.getCount() == 0L) {
            LatchedWriter latchedWriter = this;
            synchronized (latchedWriter) {
                this.writer.flush();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.checkException();
        this.await();
        this.flush();
        this.writer.close();
    }

    public void await() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e1) {
            throw new MustacheException("Interrupted while waiting for completion", e1);
        }
    }
}

