/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.Fetch;
import com.ziclix.python.sql.Procedure;
import com.ziclix.python.sql.PyCursor;
import com.ziclix.python.sql.zxJDBC;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyUnicode;
import org.python.core.codecs;

public class PyStatement
extends PyObject {
    public static final int STATEMENT_STATIC = 2;
    public static final int STATEMENT_PREPARED = 4;
    public static final int STATEMENT_CALLABLE = 8;
    private int style;
    private Object sql;
    private boolean closed;
    Statement statement;
    protected static PyList __methods__;
    protected static PyList __members__;

    public PyStatement(Statement statement, Object sql, int style) {
        this.statement = statement;
        this.sql = sql;
        this.style = style;
        this.closed = false;
    }

    public PyStatement(Statement statement, Procedure procedure) {
        this(statement, procedure, 8);
    }

    @Override
    public PyUnicode __unicode__() {
        if (this.sql instanceof String) {
            return Py.newUnicode((String)this.sql);
        }
        if (this.sql instanceof Procedure) {
            try {
                return Py.newUnicode(((Procedure)this.sql).toSql());
            }
            catch (SQLException e) {
                throw zxJDBC.makeException(e);
            }
        }
        return super.__unicode__();
    }

    @Override
    public PyString __str__() {
        return Py.newString(this.__unicode__().encode(codecs.getDefaultEncoding(), "replace"));
    }

    @Override
    public String toString() {
        return String.format("<PyStatement object at %s for [%s]", Py.idstr(this), this.__unicode__());
    }

    @Override
    public PyObject __findattr_ex__(String name) {
        if ("style".equals(name)) {
            return Py.newInteger(this.style);
        }
        if ("closed".equals(name)) {
            return Py.newBoolean(this.closed);
        }
        if ("__statement__".equals(name)) {
            return Py.java2py(this.statement);
        }
        if ("__methods__".equals(name)) {
            return __methods__;
        }
        if ("__members__".equals(name)) {
            return __members__;
        }
        return super.__findattr_ex__(name);
    }

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("classDictInit", null);
        dict.__setitem__("statement", null);
        dict.__setitem__("execute", null);
        dict.__setitem__("prepare", null);
        dict.__setitem__("STATEMENT_STATIC", null);
        dict.__setitem__("STATEMENT_PREPARED", null);
        dict.__setitem__("STATEMENT_CALLABLE", null);
    }

    public void __del__() {
        this.close();
    }

    public void execute(PyCursor cursor, PyObject params, PyObject bindings) throws SQLException {
        if (this.closed) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "statement is closed");
        }
        this.prepare(cursor, params, bindings);
        Fetch fetch = cursor.fetch;
        switch (this.style) {
            case 2: {
                if (!this.statement.execute((String)this.sql)) break;
                fetch.add(this.statement.getResultSet());
                break;
            }
            case 4: {
                PreparedStatement preparedStatement = (PreparedStatement)this.statement;
                if (!preparedStatement.execute()) break;
                fetch.add(preparedStatement.getResultSet());
                break;
            }
            case 8: {
                CallableStatement callableStatement = (CallableStatement)this.statement;
                if (callableStatement.execute()) {
                    fetch.add(callableStatement.getResultSet());
                }
                fetch.add(callableStatement, (Procedure)this.sql, params);
                break;
            }
            default: {
                throw zxJDBC.makeException(zxJDBC.ProgrammingError, zxJDBC.getString("invalidStyle"));
            }
        }
    }

    private void prepare(PyCursor cursor, PyObject params, PyObject bindings) throws SQLException {
        Procedure procedure;
        if (params == Py.None || this.style == 2) {
            return;
        }
        DataHandler datahandler = cursor.datahandler;
        int columns = 0;
        int column = 0;
        int index = params.__len__();
        PreparedStatement preparedStatement = (PreparedStatement)this.statement;
        Procedure procedure2 = procedure = this.style == 8 ? (Procedure)this.sql : null;
        if (this.style != 8) {
            columns = params.__len__();
            preparedStatement.clearParameters();
        } else {
            int n = columns = procedure.columns == Py.None ? 0 : procedure.columns.__len__();
        }
        while (columns-- > 0) {
            PyObject binding;
            column = columns + 1;
            if (procedure != null && !procedure.isInput(column)) continue;
            PyObject param = params.__getitem__(--index);
            if (bindings != Py.None && (binding = bindings.__finditem__(Py.newInteger(index))) != null) {
                try {
                    int bindingValue = binding.asInt();
                    datahandler.setJDBCObject(preparedStatement, column, param, bindingValue);
                    continue;
                }
                catch (PyException e) {
                    throw zxJDBC.makeException(zxJDBC.ProgrammingError, zxJDBC.getString("bindingValue"));
                }
            }
            datahandler.setJDBCObject(preparedStatement, column, param);
        }
    }

    public void close() {
        try {
            this.statement.close();
        }
        catch (SQLException e) {
            throw zxJDBC.makeException(e);
        }
        finally {
            this.closed = true;
        }
    }

    static {
        PyObject[] m = new PyObject[]{new PyString("close")};
        __methods__ = new PyList(m);
        m = new PyObject[]{new PyString("style"), new PyString("closed"), new PyString("__statement__")};
        __members__ = new PyList(m);
    }
}

