/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.testtools.fitnesse;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xlt.plugin.api.resultparser.ImportException;
import com.xebialabs.xlt.plugin.api.resultparser.TestResultParser;
import com.xebialabs.xlt.plugin.api.resultparser.TestRunHistorian;
import com.xebialabs.xlt.plugin.api.resultparser.TestRunHistorianAware;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xltest.testtools.fitnesse.FitNesseSuiteImporter;
import com.xebialabs.xltest.testtools.fitnesse.FitnesseSuiteImporterFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FitNesseTestResultParser
implements TestResultParser,
TestRunHistorianAware {
    private static final Logger LOG = LoggerFactory.getLogger(FitNesseTestResultParser.class);
    private TestRunHistorian testRunHistorian;

    public List<List<Event>> generateEventsFromFiles(List<OverthereFile> testResultFiles) throws ImportException {
        String testRunId = UUID.randomUUID().toString();
        ArrayList<List<Event>> result = new ArrayList<List<Event>>();
        for (OverthereFile fitNesseRoot : testResultFiles) {
            LocalFile localFile = (LocalFile)fitNesseRoot;
            File file = localFile.getFile();
            FitnesseSuiteImporterFactory fitnesseSuiteImporterFactory = new FitnesseSuiteImporterFactory(file);
            List<FitNesseSuiteImporter> importables = fitnesseSuiteImporterFactory.create();
            LOG.debug("Found {} suites ", (Object)importables.size());
            for (FitNesseSuiteImporter suiteImporter : importables) {
                String runKey = Long.toString(suiteImporter.getLastModified());
                if (this.testRunHistorian.isKnownKey(runKey)) {
                    LOG.debug("Suite with key {} has already been imported", (Object)runKey);
                    continue;
                }
                LOG.debug("Importing suite with key {}", (Object)runKey);
                List<Event> events = suiteImporter.mapSuiteToEvents(testRunId);
                result.add(events);
                testRunId = UUID.randomUUID().toString();
            }
        }
        return result;
    }

    public void setTestRunHistorian(TestRunHistorian testRunHistorian) {
        this.testRunHistorian = (TestRunHistorian)Preconditions.checkNotNull((Object)testRunHistorian, (Object)"testRunHistorian is required");
    }
}

