/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.testtools.fitnesse;

import com.google.common.base.Splitter;
import com.xebialabs.xlt.plugin.api.resultparser.ImportException;
import com.xebialabs.xlt.plugin.api.resultparser.ImportFailedException;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xltest.testtools.fitnesse.FitNesseSuiteImporter;
import com.xebialabs.xltest.testtools.fitnesse.TestSummary;
import fitnesse.reporting.history.ExecutionReport;
import fitnesse.reporting.history.PageHistory;
import fitnesse.reporting.history.SuiteExecutionReport;
import fitnesse.reporting.history.TestExecutionReport;
import fitnesse.reporting.history.TestHistory;
import fitnesse.reporting.history.TestResultRecord;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.SystemVariableSource;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.fs.FileSystemPage;
import fitnesse.wiki.fs.FileSystemPageFactory;
import fitnesse.wikitext.parser.VariableSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.FileUtil;

public class FitnesseSuiteImporterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FitnesseSuiteImporterFactory.class);
    private final File resultsDirectory;
    private final FileSystemPage root;
    private final TestHistory testHistory = new TestHistory();

    public FitnesseSuiteImporterFactory(File fitNesseRoot) {
        this.resultsDirectory = new File(fitNesseRoot, "files/testResults");
        this.root = new FileSystemPageFactory().makePage(fitNesseRoot, "FitNesseRoot", null, (VariableSource)new SystemVariableSource());
        this.testHistory.readHistoryDirectory(this.resultsDirectory);
    }

    public List<FitNesseSuiteImporter> create() throws ImportFailedException {
        ArrayList<FitNesseSuiteImporter> toImport = new ArrayList<FitNesseSuiteImporter>();
        File[] resultFiles = this.resultsDirectory.listFiles();
        if (resultFiles == null) {
            return Collections.emptyList();
        }
        try {
            for (File pageNamedFile : resultFiles) {
                if (!pageNamedFile.isDirectory()) continue;
                String pageName = pageNamedFile.getName();
                LOG.trace("Will try to make report for " + pageName);
                PageHistory pageHistory = this.getPageHistory(this.resultsDirectory, pageName);
                if (!this.pageHistoryIsSuite(pageHistory)) continue;
                for (Date date : pageHistory.datesInChronologicalOrder()) {
                    Object executionReport = this.getExecutionReport(pageHistory, date);
                    if (!(executionReport instanceof SuiteExecutionReport)) continue;
                    FitNesseSuiteImporter fitNesseSuiteImporter = new FitNesseSuiteImporter(this, (SuiteExecutionReport)executionReport, pageName);
                    toImport.add(fitNesseSuiteImporter);
                }
            }
        }
        catch (Exception e) {
            throw new ImportFailedException((Throwable)e);
        }
        Collections.sort(toImport, new Comparator<FitNesseSuiteImporter>(){

            @Override
            public int compare(FitNesseSuiteImporter o1, FitNesseSuiteImporter o2) {
                int cmp = Long.valueOf(o1.getLastModified()).compareTo(o2.getLastModified());
                if (cmp != 0) {
                    return cmp;
                }
                return o1.getPageName().compareTo(o2.getPageName());
            }
        });
        return toImport;
    }

    public List<Event> produceEventsForReport(String testRunId, SuiteExecutionReport suiteExecutionReport) throws ImportException {
        ArrayList<Event> result = new ArrayList<Event>();
        for (SuiteExecutionReport.PageHistoryReference reference : suiteExecutionReport.getPageHistoryReferences()) {
            Set<String> tags = this.findTags(reference);
            String firstErrorMessage = this.findFirstErrorMessage(reference);
            TestSummary testSummary = new TestSummary(FitnesseSuiteImporterFactory.extractHierarchy(reference.getPageName(), '.'), tags, reference.getTime(), (int)reference.getRunTimeInMillis(), reference.getTestSummary().getRight(), reference.getTestSummary().getWrong(), reference.getTestSummary().getExceptions(), firstErrorMessage);
            Event event = new Event("functionalResult", testSummary.toMap()).setTestRunId(testRunId);
            result.add(event);
        }
        return result;
    }

    public static List<String> extractHierarchy(String eventName, char separator) {
        return Splitter.on((char)separator).splitToList((CharSequence)eventName);
    }

    private Set<String> findTags(SuiteExecutionReport.PageHistoryReference reference) {
        WikiPagePath wikiPagePath = PathParser.parse((String)reference.getPageName());
        PageCrawler pageCrawler = this.root.getPageCrawler();
        Set<String> tags = FitnesseSuiteImporterFactory.set(new String[0]);
        if (pageCrawler.pageExists(wikiPagePath)) {
            WikiPage thePage = pageCrawler.getPage(wikiPagePath);
            tags = this.findTags(thePage);
        }
        return tags;
    }

    private Set<String> findTags(WikiPage page) {
        if (page == null || page.isRoot()) {
            return FitnesseSuiteImporterFactory.set(new String[0]);
        }
        String tags = page.getData().getAttribute("Suites");
        Set<String> tagSet = this.isNotBlank(tags) ? FitnesseSuiteImporterFactory.set(tags.split(",")) : FitnesseSuiteImporterFactory.set(new String[0]);
        tagSet.addAll(this.findTags(page.getParent()));
        return tagSet;
    }

    private String findFirstErrorMessage(SuiteExecutionReport.PageHistoryReference reference) {
        String firstErrorMessage = null;
        try {
            PageHistory pageHistory = this.getPageHistory(this.resultsDirectory, reference.getPageName());
            if (pageHistory == null) {
                return "No test results found for page: " + reference.getPageName();
            }
            TestExecutionReport testExecutionReport = (TestExecutionReport)this.getExecutionReport(pageHistory, new Date(reference.getTime()));
            firstErrorMessage = this.findFirstErrorMessage(testExecutionReport);
        }
        catch (Exception e) {
            LOG.warn("Unable to find test result file for test page {}", (Object)reference.getPageName());
            LOG.debug("Could not determine first error message", (Throwable)e);
        }
        return firstErrorMessage;
    }

    private String findFirstErrorMessage(TestExecutionReport testExecutionReport) {
        TestExecutionReport.TestResult testResult = (TestExecutionReport.TestResult)testExecutionReport.getResults().get(0);
        for (TestExecutionReport.InstructionResult instructionResult : testResult.getInstructions()) {
            for (TestExecutionReport.Expectation expectation : instructionResult.getExpectations()) {
                if ("fail".equals(expectation.getStatus())) {
                    return String.format("Actual: '%s'; Expected: '%s'", expectation.getActual(), expectation.getExpected());
                }
                if (!"error".equals(expectation.getStatus())) continue;
                return expectation.getEvaluationMessage();
            }
        }
        return null;
    }

    private <T extends ExecutionReport> T getExecutionReport(PageHistory pageHistory, Date date) throws Exception {
        TestResultRecord testResultRecord = pageHistory.get(date);
        return (T)ExecutionReport.makeReport((String)FileUtil.getFileContent((File)testResultRecord.getFile()));
    }

    private PageHistory getPageHistory(File resultsDirectory, String pageName) throws FileNotFoundException {
        if (!resultsDirectory.canRead()) {
            throw new FileNotFoundException("Could not find " + resultsDirectory);
        }
        return this.testHistory.getPageHistory(pageName);
    }

    private boolean pageHistoryIsSuite(PageHistory pageHistory) throws Exception {
        if (pageHistory == null) {
            return false;
        }
        Object report = this.getExecutionReport(pageHistory, pageHistory.getLatestDate());
        return report instanceof SuiteExecutionReport;
    }

    public static Set<String> set(String ... tags) {
        TreeSet<String> tagSet = new TreeSet<String>();
        for (String tag : tags) {
            String trimmed = tag.trim();
            if ("".equals(trimmed)) continue;
            tagSet.add(trimmed);
        }
        return tagSet;
    }

    private boolean isNotBlank(String tags) {
        return tags != null && !"".equals(tags);
    }
}

