/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import java.util.Iterator;
import org.modeshape.common.function.Function;

public class DelegateIterator<T, V>
implements Iterator<T> {
    private final Function<V, T> converter;
    private final Iterator<V> delegate;

    public static <T, V> Iterator<T> around(Iterator<V> delegate, Function<V, T> converter) {
        return new DelegateIterator<T, V>(delegate, converter);
    }

    protected DelegateIterator(Iterator<V> delegate, Function<V, T> converter) {
        this.converter = converter;
        this.delegate = delegate;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public T next() {
        return this.converter.apply(this.delegate.next());
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }
}

