/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Iterator;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.ImportPkg;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Version;

class Pkg {
    final String pkg;
    final ArrayList<ExportPkg> exporters = new ArrayList(1);
    final ArrayList<ImportPkg> importers = new ArrayList();
    final ArrayList<ExportPkg> providers = new ArrayList(1);
    static final Util.Comparator<ExportPkg, ExportPkg> epComp = new Util.Comparator<ExportPkg, ExportPkg>(){

        @Override
        public int compare(ExportPkg a, ExportPkg b) {
            int d = a.version.compareTo(b.version);
            if (d == 0) {
                long ld = b.bpkgs.bg.bundle.id - a.bpkgs.bg.bundle.id;
                if (ld < 0L) {
                    d = -1;
                } else if (ld > 0L) {
                    d = 1;
                }
            }
            return d;
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((ExportPkg)x0, (ExportPkg)x1);
        }
    };
    static final Util.Comparator<ImportPkg, ImportPkg> ipComp = new Util.Comparator<ImportPkg, ImportPkg>(){

        @Override
        public int compare(ImportPkg a, ImportPkg b) {
            int d = a.packageRange == null ? (b.packageRange == null ? 0 : Version.emptyVersion.compareTo(b.packageRange.getLeft())) : (b.packageRange == null ? a.packageRange.getLeft().compareTo(Version.emptyVersion) : a.packageRange.getLeft().compareTo(b.packageRange.getLeft()));
            if (d == 0) {
                long ld = b.bpkgs.bg.bundle.id - a.bpkgs.bg.bundle.id;
                if (ld < 0L) {
                    d = -1;
                } else if (ld > 0L) {
                    d = 1;
                }
            }
            return d;
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((ImportPkg)x0, (ImportPkg)x1);
        }
    };

    Pkg(String pkg) {
        this.pkg = pkg;
    }

    synchronized void addExporter(ExportPkg ep) {
        int i = Math.abs(Util.binarySearch(this.exporters, epComp, ep) + 1);
        this.exporters.add(i, ep);
        ep.attachPkg(this);
    }

    synchronized boolean removeExporter(ExportPkg p) {
        this.providers.remove(p);
        this.exporters.remove(p);
        p.detachPkg();
        return true;
    }

    synchronized void addImporter(ImportPkg ip) {
        int i = Math.abs(Util.binarySearch(this.importers, ipComp, ip) + 1);
        this.importers.add(i, ip);
        ip.attachPkg(this);
    }

    synchronized void removeImporter(ImportPkg ip) {
        this.importers.remove(ip);
        ip.detachPkg();
    }

    synchronized void addProvider(ExportPkg ep) {
        int i = Util.binarySearch(this.providers, epComp, ep);
        if (i < 0) {
            this.providers.add(-i - 1, ep);
        }
    }

    synchronized ExportPkg getBestProvider() {
        if (!this.providers.isEmpty()) {
            return this.providers.get(0);
        }
        ExportPkg best = null;
        Iterator<ExportPkg> i$ = this.exporters.iterator();
        while (i$.hasNext()) {
            ExportPkg exportPkg;
            ExportPkg ep = exportPkg = i$.next();
            if (!ep.bpkgs.bg.bundle.isResolved() || best != null && best.version.compareTo(ep.version) >= 0) continue;
            best = ep;
        }
        return best;
    }

    synchronized boolean isEmpty() {
        return this.exporters.size() == 0 && this.importers.size() == 0;
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int level) {
        StringBuffer sb = new StringBuffer();
        sb.append("Pkg[");
        if (level > 0) {
            sb.append("pkg=" + this.pkg);
        }
        if (level > 1) {
            sb.append(", providers=" + this.providers);
        }
        if (level > 2) {
            sb.append(", exporters=" + this.exporters);
        }
        sb.append("]");
        return ((Object)sb).toString();
    }
}

