/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Enumeration;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FrameworkContext;
import org.osgi.service.permissionadmin.PermissionInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PermissionInfoPermissions
extends PermissionCollection {
    private static final long serialVersionUID = 1L;
    private Permissions pc;
    private volatile PermissionInfo[] pinfo;
    private int unresolved;
    private final File dataRoot;
    private final FrameworkContext framework;
    private final Debug debug;
    static final Permission allPermission = new AllPermission();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$FilePermission;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PermissionInfoPermissions(FrameworkContext fw, File root, InputStream ps) {
        this.framework = fw;
        this.debug = fw.debug;
        this.dataRoot = root;
        try {
            String l;
            BufferedReader dis = new BufferedReader(new InputStreamReader(ps));
            ArrayList<PermissionInfo> tmp = new ArrayList<PermissionInfo>();
            while ((l = dis.readLine()) != null) {
                if ((l = l.trim()).startsWith("#") || l.startsWith("//") || l.length() == 0) continue;
                try {
                    tmp.add(new PermissionInfo(l));
                }
                catch (Exception e) {}
            }
            if (!tmp.isEmpty()) {
                this.pinfo = tmp.toArray(new PermissionInfo[tmp.size()]);
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                ps.close();
            }
            catch (IOException _ignore) {}
        }
        if (this.pinfo != null) {
            this.unresolved = this.pinfo.length;
        } else {
            this.unresolved = 0;
            this.pc = new Permissions();
        }
    }

    PermissionInfoPermissions(FrameworkContext fw, File root, PermissionInfo[] pinfo) {
        this.framework = fw;
        this.dataRoot = root;
        this.debug = fw.debug;
        if (pinfo != null) {
            this.pinfo = (PermissionInfo[])pinfo.clone();
            this.unresolved = pinfo.length;
        } else {
            this.unresolved = 0;
        }
        if (this.unresolved == 0) {
            this.pc = new Permissions();
        }
    }

    @Override
    public void add(Permission permission) {
        throw new UnsupportedOperationException("Readonly");
    }

    @Override
    public Enumeration<Permission> elements() {
        if (this.unresolved != 0) {
            this.resolve();
        }
        return this.pc.elements();
    }

    @Override
    public boolean implies(Permission permission) {
        if (this.unresolved != 0) {
            this.resolve();
        }
        return this.pc.implies(permission);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly() {
    }

    private synchronized void resolve() {
        if (this.pinfo == null) {
            return;
        }
        if (this.pc == null) {
            this.pc = new Permissions();
        }
        for (int i = 0; i < this.pinfo.length; ++i) {
            if (this.pinfo[i] != null) {
                Permission p = this.makePermission(this.pinfo[i]);
                if (p == null) continue;
                this.pc.add(p);
                --this.unresolved;
                this.pinfo[i] = null;
                continue;
            }
            if (!this.debug.permissions) continue;
            this.debug.println(((Object)new StringBuffer().append("makePermission: Failed to create permission ").append(this.pinfo[i])).toString());
        }
        if (this.unresolved == 0) {
            this.pinfo = null;
        }
    }

    private Permission makePermission(PermissionInfo pi) {
        String t = pi.getType();
        if ("java.security.AllPermission".equals(t)) {
            return allPermission;
        }
        ClassLoader cl = this.framework.getClassLoader(t);
        if (cl == null) {
            return null;
        }
        String a = pi.getActions();
        String n = pi.getName();
        try {
            Class<?> pc = Class.forName(t, true, cl);
            Constructor<?> c = pc.getConstructor(class$java$lang$String == null ? (class$java$lang$String = PermissionInfoPermissions.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PermissionInfoPermissions.class$("java.lang.String")) : class$java$lang$String);
            if ((class$java$io$FilePermission == null ? (class$java$io$FilePermission = PermissionInfoPermissions.class$("java.io.FilePermission")) : class$java$io$FilePermission).equals(pc) && !"<<ALL FILES>>".equals(n)) {
                File f = new File(n);
                if (!f.isAbsolute()) {
                    if (this.dataRoot == null) {
                        return null;
                    }
                    f = new File(this.dataRoot, n);
                }
                n = f.getPath();
            }
            return (Permission)c.newInstance(n, a);
        }
        catch (ClassNotFoundException ignore) {
            return new UnresolvedPermission(t, n, a, null);
        }
        catch (NoSuchMethodException ignore) {
        }
        catch (InstantiationException ignore) {
        }
        catch (IllegalAccessException ignore) {
        }
        catch (InvocationTargetException ignore) {
            // empty catch block
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

