/*
 * Decompiled with CFR 0.152.
 */
package org.scannotation.archiveiterator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.scannotation.archiveiterator.Filter;
import org.scannotation.archiveiterator.StreamIterator;

public class FileIterator
implements StreamIterator {
    private ArrayList files = new ArrayList();
    private int index = 0;

    public FileIterator(File file, Filter filter) {
        try {
            FileIterator.create(this.files, file, filter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static void create(List list, File dir, Filter filter) throws Exception {
        FileIterator.create(list, dir, filter, dir.getCanonicalPath());
    }

    protected static void create(List list, File dir, Filter filter, String prefix) throws Exception {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileIterator.create(list, files[i], filter, prefix);
                continue;
            }
            String path = files[i].getCanonicalPath();
            String relativePath = path.substring(prefix.length() + 1);
            if (File.separatorChar == '\\') {
                relativePath = relativePath.replace('\\', '/');
            }
            if (filter != null && !filter.accepts(relativePath)) continue;
            list.add(files[i]);
        }
    }

    public InputStream next() {
        if (this.index >= this.files.size()) {
            return null;
        }
        File fp = (File)this.files.get(this.index++);
        try {
            return new FileInputStream(fp);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
    }
}

