/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.xsite.BaseBackupInterceptor;
import org.infinispan.remoting.transport.BackupResponse;

public class OptimisticBackupInterceptor
extends BaseBackupInterceptor {
    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!this.shouldInvokeRemoteTxCommand(ctx)) {
            return super.visitPrepareCommand(ctx, command);
        }
        boolean isTxFromRemoteSite = this.isTxFromRemoteSite(command.getGlobalTransaction());
        if (isTxFromRemoteSite) {
            return this.invokeNextInterceptor(ctx, command);
        }
        BackupResponse backupResponse = this.backupSender.backupPrepare(command);
        Object result = this.invokeNextInterceptor(ctx, command);
        this.backupSender.processResponses(backupResponse, command, ctx.getTransaction());
        return result;
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!this.shouldInvokeRemoteTxCommand(ctx)) {
            return super.visitCommitCommand(ctx, command);
        }
        if (this.isTxFromRemoteSite(command.getGlobalTransaction())) {
            return this.invokeNextInterceptor(ctx, command);
        }
        BackupResponse backupResponse = this.backupSender.backupCommit(command);
        Object result = this.invokeNextInterceptor(ctx, command);
        this.backupSender.processResponses(backupResponse, command, ctx.getTransaction());
        return result;
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (!this.shouldRollbackRemoteTxCommand(ctx)) {
            return super.visitRollbackCommand(ctx, command);
        }
        if (this.isTxFromRemoteSite(command.getGlobalTransaction())) {
            return this.invokeNextInterceptor(ctx, command);
        }
        BackupResponse backupResponse = this.backupSender.backupRollback(command);
        Object result = this.invokeNextInterceptor(ctx, command);
        this.backupSender.processResponses(backupResponse, command, ctx.getTransaction());
        return result;
    }

    private boolean shouldRollbackRemoteTxCommand(TxInvocationContext ctx) {
        return this.shouldInvokeRemoteTxCommand(ctx) && this.hasBeenPrepared((LocalTxInvocationContext)ctx);
    }

    private boolean hasBeenPrepared(LocalTxInvocationContext ctx) {
        return !ctx.getRemoteLocksAcquired().isEmpty();
    }
}

