/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValueFactory;
import org.modeshape.jcr.api.Namespaced;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;

@ThreadSafe
abstract class AbstractJcrItem
implements Item,
Namespaced {
    protected final JcrSession session;

    protected AbstractJcrItem(JcrSession session) {
        this.session = session;
    }

    final JcrSession session() {
        return this.session;
    }

    final String workspaceName() {
        return this.session.workspaceName();
    }

    protected final void checkSession() throws RepositoryException {
        this.session.checkLive();
    }

    final ExecutionContext context() {
        return this.session.context();
    }

    final NodeCache cache() {
        return this.session().cache();
    }

    final Name nameFrom(String name) {
        return (Name)this.context().getValueFactories().getNameFactory().create(name);
    }

    final Path pathFrom(String path) {
        return (Path)this.context().getValueFactories().getPathFactory().create(path);
    }

    final Path.Segment segmentFrom(String segment) {
        return this.context().getValueFactories().getPathFactory().createSegment(segment);
    }

    final Path.Segment segmentFrom(Name segment) {
        return this.context().getValueFactories().getPathFactory().createSegment(segment);
    }

    final NamespaceRegistry namespaces() {
        return this.context().getNamespaceRegistry();
    }

    final JcrValueFactory valueFactory() {
        return this.session().valueFactory();
    }

    abstract Path path() throws RepositoryException;

    public Item getAncestor(int depth) throws RepositoryException {
        this.checkSession();
        if (depth < 0) {
            throw new ItemNotFoundException(JcrI18n.noNegativeDepth.text(new Object[]{depth}));
        }
        depth = this.getDepth() - depth;
        if (depth < 0) {
            throw new ItemNotFoundException(JcrI18n.tooDeep.text(new Object[]{depth}));
        }
        AbstractJcrItem ancestor = this;
        while (--depth >= 0) {
            ancestor = ancestor.getParent();
        }
        return ancestor;
    }

    public int getDepth() throws RepositoryException {
        this.checkSession();
        return this.path().size();
    }

    public abstract AbstractJcrNode getParent() throws ItemNotFoundException, RepositoryException;

    protected boolean isSameRepository(Item otherItem) throws RepositoryException {
        assert (this.getSession() != null);
        assert (otherItem.getSession() != null);
        assert (this.getSession().getRepository() != null);
        assert (otherItem.getSession().getRepository() != null);
        return this.getSession().getRepository() == otherItem.getSession().getRepository();
    }
}

