/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.basic.BasicEmptyProperty;
import org.modeshape.jcr.value.basic.BasicMultiValueProperty;
import org.modeshape.jcr.value.basic.BasicSingleValueProperty;

@Immutable
public class BasicPropertyFactory
implements PropertyFactory {
    private final ValueFactories factories;

    public BasicPropertyFactory(ValueFactories valueFactories) {
        CheckArg.isNotNull((Object)valueFactories, (String)"value factories");
        this.factories = valueFactories;
    }

    @Override
    public Property create(Name name, Path value) {
        return new BasicSingleValueProperty(name, value);
    }

    @Override
    public Property create(Name name, Iterable<?> values) {
        return this.create(name, PropertyType.OBJECT, values);
    }

    @Override
    public Property create(Name name, Iterator<?> values) {
        return this.create(name, PropertyType.OBJECT, values);
    }

    @Override
    public Property create(Name name) {
        return new BasicEmptyProperty(name);
    }

    @Override
    public Property create(Name name, Object value) {
        return this.create(name, PropertyType.OBJECT, value);
    }

    @Override
    public Property create(Name name, Object[] values) {
        return this.create(name, PropertyType.OBJECT, values);
    }

    @Override
    public Property create(Name name, PropertyType desiredType, Object firstValue) {
        CheckArg.isNotNull((Object)name, (String)"name");
        if (desiredType == null) {
            desiredType = PropertyType.OBJECT;
        }
        ValueFactory<?> factory = this.factories.getValueFactory(desiredType);
        Object value = firstValue;
        if (value instanceof Path) {
            value = factory.create(value);
            return new BasicSingleValueProperty(name, value);
        }
        if (value instanceof Collection) {
            return this.create(name, desiredType, (Iterable)value);
        }
        if (value instanceof Iterator) {
            return this.create(name, desiredType, (Iterator)value);
        }
        if (value instanceof Object[]) {
            return this.create(name, desiredType, (Object[])value);
        }
        value = factory.create(value);
        return new BasicSingleValueProperty(name, value);
    }

    @Override
    public Property create(Name name, PropertyType desiredType, Object[] values) {
        CheckArg.isNotNull((Object)name, (String)"name");
        if (values == null) {
            return new BasicEmptyProperty(name);
        }
        int len = values.length;
        if (len == 0) {
            return new BasicEmptyProperty(name);
        }
        if (desiredType == null) {
            desiredType = PropertyType.OBJECT;
        }
        ValueFactory<?> factory = this.factories.getValueFactory(desiredType);
        ArrayList<Object> valueList = new ArrayList<Object>(len);
        for (int i = 0; i != len; ++i) {
            Object value = factory.create(values[i]);
            if (value == null) continue;
            valueList.add(value);
        }
        return new BasicMultiValueProperty(name, valueList);
    }

    @Override
    public Property create(Name name, PropertyType desiredType, Iterable<?> values) {
        CheckArg.isNotNull((Object)name, (String)"name");
        ArrayList<Object> valueList = null;
        if (values instanceof Collection) {
            Collection originalValues = (Collection)values;
            if (originalValues.isEmpty()) {
                return new BasicEmptyProperty(name);
            }
            valueList = new ArrayList(originalValues.size());
        } else {
            valueList = new ArrayList<Object>();
        }
        if (desiredType == null) {
            desiredType = PropertyType.OBJECT;
        }
        ValueFactory<?> factory = this.factories.getValueFactory(desiredType);
        for (Object value : values) {
            Object newValue = factory.create(value);
            if (newValue == null) continue;
            valueList.add(newValue);
        }
        if (valueList.isEmpty()) {
            return new BasicEmptyProperty(name);
        }
        return new BasicMultiValueProperty(name, valueList);
    }

    @Override
    public Property create(Name name, PropertyType desiredType, Iterator<?> values) {
        CheckArg.isNotNull((Object)name, (String)"name");
        ArrayList<Object> valueList = new ArrayList<Object>();
        if (desiredType == null) {
            desiredType = PropertyType.OBJECT;
        }
        ValueFactory<?> factory = this.factories.getValueFactory(desiredType);
        while (values.hasNext()) {
            Object value = values.next();
            if ((value = factory.create(value)) == null) continue;
            valueList.add(value);
        }
        if (valueList.isEmpty()) {
            return new BasicEmptyProperty(name);
        }
        return new BasicMultiValueProperty(name, valueList);
    }
}

