/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DisjunctionScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

final class DisjunctionSumScorer
extends DisjunctionScorer {
    private double score;
    private final float[] coord;

    DisjunctionSumScorer(Weight weight, Scorer[] subScorers, float[] coord) {
        super(weight, subScorers);
        this.coord = coord;
    }

    @Override
    protected void reset() {
        this.score = 0.0;
    }

    @Override
    protected void accum(Scorer subScorer) throws IOException {
        this.score += (double)subScorer.score();
    }

    @Override
    protected float getFinal() {
        return (float)this.score * this.coord[this.freq];
    }
}

