/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.plugins;

import fitnesse.ConfigurationParameter;
import fitnesse.authentication.Authenticator;
import fitnesse.components.ComponentFactory;
import fitnesse.components.ComponentInstantiationException;
import fitnesse.plugins.LegacyPluginFeatureFactory;
import fitnesse.plugins.PluginException;
import fitnesse.plugins.PluginFeatureFactory;
import fitnesse.plugins.PluginFeatureFactoryBase;
import fitnesse.responders.ResponderFactory;
import fitnesse.responders.editing.ContentFilter;
import fitnesse.testrunner.TestSystemFactoryRegistry;
import fitnesse.testsystems.TestSystemFactory;
import fitnesse.testsystems.slim.CustomComparator;
import fitnesse.testsystems.slim.CustomComparatorRegistry;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SlimTableFactory;
import fitnesse.wiki.WikiPageFactory;
import fitnesse.wiki.WikiPageFactoryRegistry;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class PropertyBasedPluginFeatureFactory
extends PluginFeatureFactoryBase {
    private final ComponentFactory componentFactory;

    public static Collection<PluginFeatureFactory> loadFromProperties(ComponentFactory componentFactory) throws PluginException {
        PropertyBasedPluginFeatureFactory propBased = new PropertyBasedPluginFeatureFactory(componentFactory);
        Collection<PluginFeatureFactory> legacyWrappers = PropertyBasedPluginFeatureFactory.createWrappersForLegacyPlugins(componentFactory);
        ArrayList<PluginFeatureFactory> all = new ArrayList<PluginFeatureFactory>(legacyWrappers.size() + 1);
        all.add(propBased);
        all.addAll(legacyWrappers);
        return all;
    }

    private PropertyBasedPluginFeatureFactory(ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }

    @Override
    public void registerResponders(final ResponderFactory responderFactory) throws PluginException {
        this.forEachNamedObject(ConfigurationParameter.RESPONDERS, new Registrar(){

            public void register(String key, Class clazz) {
                responderFactory.addResponder(key, clazz);
                PropertyBasedPluginFeatureFactory.this.LOG.info("Loaded responder " + key + ": " + clazz.getName());
            }
        });
    }

    private String[] getListFromProperties(ConfigurationParameter propertyName) {
        return PropertyBasedPluginFeatureFactory.getListFromProperties(this.componentFactory, propertyName);
    }

    private static String[] getListFromProperties(ComponentFactory componentFactory, ConfigurationParameter propertyName) {
        String value = componentFactory.getProperty(propertyName.getKey());
        if (value == null) {
            return null;
        }
        return value.split(",");
    }

    @Override
    public Authenticator getAuthenticator() {
        return (Authenticator)this.componentFactory.createComponent(ConfigurationParameter.AUTHENTICATOR);
    }

    @Override
    public void registerSymbolTypes(SymbolProvider symbolProvider) throws PluginException {
        String[] symbolTypeNames = this.getListFromProperties(ConfigurationParameter.SYMBOL_TYPES);
        if (symbolTypeNames != null) {
            for (String symbolTypeName : symbolTypeNames) {
                Class symbolTypeClass = PropertyBasedPluginFeatureFactory.forName(symbolTypeName.trim());
                symbolProvider.add((SymbolType)this.componentFactory.createComponent(symbolTypeClass));
                this.LOG.info("Loaded SymbolType " + symbolTypeClass.getName());
            }
        }
    }

    @Override
    public void registerWikiPageFactories(WikiPageFactoryRegistry registrar) throws PluginException {
        String[] factoryNames = this.getListFromProperties(ConfigurationParameter.WIKI_PAGE_FACTORIES);
        if (factoryNames != null) {
            for (String factoryName : factoryNames) {
                Class factory = PropertyBasedPluginFeatureFactory.forName(factoryName.trim());
                registrar.registerWikiPageFactory((WikiPageFactory)this.componentFactory.createComponent(factory));
                this.LOG.info("Loaded WikiPageFactory " + factory.getName());
            }
        }
    }

    @Override
    public ContentFilter getContentFilter() {
        return (ContentFilter)this.componentFactory.createComponent(ConfigurationParameter.CONTENT_FILTER);
    }

    @Override
    public void registerSlimTables(final SlimTableFactory slimTableFactory) throws PluginException {
        this.forEachNamedObject(ConfigurationParameter.SLIM_TABLES, new Registrar<SlimTable>(){

            @Override
            public void register(String key, Class<SlimTable> clazz) {
                slimTableFactory.addTableType(key, clazz);
                PropertyBasedPluginFeatureFactory.this.LOG.info("Loaded custom SLiM table type " + key + ":" + clazz.getName());
            }
        });
    }

    @Override
    public void registerCustomComparators(final CustomComparatorRegistry customComparatorRegistry) throws PluginException {
        this.forEachNamedObject(ConfigurationParameter.CUSTOM_COMPARATORS, new Registrar<CustomComparator>(){

            @Override
            public void register(String key, Class<CustomComparator> clazz) {
                customComparatorRegistry.addCustomComparator(key, PropertyBasedPluginFeatureFactory.this.componentFactory.createComponent(clazz));
                PropertyBasedPluginFeatureFactory.this.LOG.info("Loaded custom comparator " + key + ": " + clazz.getName());
            }
        });
    }

    @Override
    public void registerTestSystemFactories(final TestSystemFactoryRegistry registrar) throws PluginException {
        this.forEachNamedObject(ConfigurationParameter.TEST_SYSTEMS, new Registrar<TestSystemFactory>(){

            @Override
            public void register(String key, Class<TestSystemFactory> clazz) {
                registrar.registerTestSystemFactory(key, PropertyBasedPluginFeatureFactory.this.componentFactory.createComponent(clazz));
                PropertyBasedPluginFeatureFactory.this.LOG.info("Loaded test system " + key + ": " + clazz.getName());
            }
        });
    }

    private void forEachNamedObject(ConfigurationParameter parameter, Registrar registrar) throws PluginException {
        String[] propList = this.getListFromProperties(parameter);
        if (propList != null) {
            for (String entry : propList) {
                entry = entry.trim();
                int colonIndex = entry.lastIndexOf(58);
                String prefix = entry.substring(0, colonIndex);
                String className = entry.substring(colonIndex + 1, entry.length());
                this.register(registrar, prefix, className);
            }
        }
    }

    private void register(Registrar registrar, String prefix, String className) throws PluginException {
        try {
            registrar.register(prefix, PropertyBasedPluginFeatureFactory.forName(className));
        }
        catch (ComponentInstantiationException e) {
            throw new PluginException("Can not register plug in " + className, e);
        }
    }

    private static Collection<PluginFeatureFactory> createWrappersForLegacyPlugins(ComponentFactory componentFactory) throws PluginException {
        String[] pluginNames = PropertyBasedPluginFeatureFactory.getListFromProperties(componentFactory, ConfigurationParameter.PLUGINS);
        if (pluginNames == null) {
            return Collections.emptyList();
        }
        ArrayList<PluginFeatureFactory> providers = new ArrayList<PluginFeatureFactory>(pluginNames.length);
        for (String pluginName : pluginNames) {
            Class pluginClass = PropertyBasedPluginFeatureFactory.forName(pluginName);
            Object plugin = componentFactory.createComponent(pluginClass);
            providers.add(new LegacyPluginFeatureFactory(plugin));
        }
        return providers;
    }

    private static <T> Class<T> forName(String className) throws PluginException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Unable to load class " + className, e);
        }
    }

    private static interface Registrar<T> {
        public void register(String var1, Class<T> var2);
    }
}

