/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.authentication.InsecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public abstract class BasicResponder
implements SecureResponder {
    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        WikiPage requestedPage = this.getRequestedPage(request, context);
        Response response = requestedPage == null ? this.pageNotFoundResponse(context, request) : this.responseWith(this.contentFrom(context, request, requestedPage));
        return response;
    }

    protected WikiPage getRequestedPage(Request request, FitNesseContext context) {
        WikiPagePath path = PathParser.parse(request.getResource());
        WikiPage requestedPage = context.getRootPage().getPageCrawler().getPage(path);
        return requestedPage;
    }

    protected abstract String contentFrom(FitNesseContext var1, Request var2, WikiPage var3);

    protected Response pageNotFoundResponse(FitNesseContext context, Request request) {
        return new NotFoundResponder().makeResponse(context, request);
    }

    protected Response responseWith(String content) {
        SimpleResponse response = new SimpleResponse();
        response.setContentType(this.getContentType());
        response.setContent(content);
        return response;
    }

    protected String getContentType() {
        return Response.Format.HTML.getContentType();
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new InsecureOperation();
    }
}

