/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.html.HtmlUtil;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.editing.SaveRecorder;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.ArrayList;

public class MergeResponder
implements Responder {
    private Request request;
    private String newContent;
    private String existingContent;
    private String resource;

    public MergeResponder(Request request) {
        this.request = request;
    }

    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        SimpleResponse response = new SimpleResponse();
        this.resource = this.request.getResource();
        WikiPagePath path = PathParser.parse(this.resource);
        WikiPage page = context.getRootPage().getPageCrawler().getPage(path);
        this.existingContent = page.getData().getContent();
        this.newContent = this.request.getInput("pageContent");
        response.setContent(this.makePageHtml(context));
        return response;
    }

    private String makePageHtml(FitNesseContext context) {
        HtmlPage page = context.pageFactory.newPage();
        page.setTitle("Merge " + this.resource);
        page.setPageTitle(new PageTitle("Merge Changes", PathParser.parse(this.resource)));
        page.setMainTemplate("mergePage");
        page.put("editTime", SaveRecorder.timeStamp());
        page.put("ticketId", SaveRecorder.newTicket());
        page.put("oldContent", HtmlUtil.escapeHTML(this.existingContent));
        page.put("newContent", this.newContent);
        this.addHiddenAttributes(page);
        return page.html();
    }

    private void addHiddenAttributes(HtmlPage page) {
        if (this.request.hasInput("PageType")) {
            page.put("pageType", this.request.getInput("PageType"));
        }
        ArrayList<String> attributes = new ArrayList<String>();
        for (int i = 0; i < PageData.NON_SECURITY_ATTRIBUTES.length; ++i) {
            String attribute = PageData.NON_SECURITY_ATTRIBUTES[i];
            if (!this.request.hasInput(attribute)) continue;
            attributes.add(attribute);
        }
        if (this.request.hasInput("Prune")) {
            attributes.add("Prune");
        }
        page.put("attributes", attributes);
    }
}

