/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.ApplicationVariableSource;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageCrawlerImpl;
import fitnesse.wiki.PageVariableSource;
import fitnesse.wiki.UrlPathVariableSource;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikitextPage;
import fitnesse.wikitext.parser.CompositeVariableSource;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.VariableSource;
import fitnesse.wikitext.parser.WikiSourcePage;

public abstract class BaseWikiPage
implements WikiPage,
WikitextPage {
    private final String name;
    private final WikiPage parent;
    private final VariableSource variableSource;
    private ParsingPage parsingPage;
    private Symbol syntaxTree;

    protected BaseWikiPage(String name, VariableSource variableSource) {
        this(name, null, variableSource);
    }

    protected BaseWikiPage(String name, WikiPage parent) {
        this(name, parent, parent instanceof BaseWikiPage ? ((BaseWikiPage)parent).variableSource : null);
    }

    protected BaseWikiPage(String name, WikiPage parent, VariableSource variableSource) {
        this.name = name;
        this.parent = parent;
        this.variableSource = variableSource;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PageCrawler getPageCrawler() {
        return new PageCrawlerImpl(this);
    }

    @Override
    public WikiPage getParent() {
        return this.parent == null ? this : this.parent;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null || this.parent == this;
    }

    protected VariableSource getVariableSource() {
        return this.variableSource;
    }

    @Override
    public String getVariable(String name) {
        ParsingPage parsingPage = this.getParsingPage();
        Maybe<String> variable = parsingPage.findVariable(name);
        if (variable.isNothing()) {
            return null;
        }
        Parser parser = Parser.make(parsingPage, "", SymbolProvider.variableDefinitionSymbolProvider);
        return new HtmlTranslator(null, parsingPage).translate(parser.parseWithParent(variable.getValue(), null));
    }

    @Override
    public String getHtml() {
        return new HtmlTranslator(new WikiSourcePage(this), this.getParsingPage()).translateTree(this.getSyntaxTree());
    }

    @Override
    public ParsingPage getParsingPage() {
        this.parse();
        return this.parsingPage;
    }

    @Override
    public Symbol getSyntaxTree() {
        this.parse();
        return this.syntaxTree;
    }

    private void parse() {
        if (this.syntaxTree == null) {
            this.parsingPage = BaseWikiPage.makeParsingPage(this);
            this.syntaxTree = Parser.make(this.parsingPage, this.getData().getContent()).parse();
        }
    }

    protected void resetCache() {
        this.parsingPage = null;
        this.syntaxTree = null;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.name;
    }

    @Override
    public int compareTo(Object o) {
        try {
            return this.getPageCrawler().getFullPath().compareTo(((WikiPage)o).getPageCrawler().getFullPath());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WikiPage)) {
            return false;
        }
        try {
            return this.getPageCrawler().getFullPath().equals(((WikiPage)o).getPageCrawler().getFullPath());
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getPageCrawler().getFullPath().hashCode();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static ParsingPage makeParsingPage(BaseWikiPage page) {
        ParsingPage.Cache cache = new ParsingPage.Cache();
        CompositeVariableSource compositeVariableSource = new CompositeVariableSource(new ApplicationVariableSource(page.variableSource), new PageVariableSource(page), new UserVariableSource(page.variableSource), cache, new ParentPageVariableSource(page), page.variableSource);
        return new ParsingPage(new WikiSourcePage(page), compositeVariableSource, cache);
    }

    public static class ParentPageVariableSource
    implements VariableSource {
        private final WikiPage page;

        public ParentPageVariableSource(WikiPage page) {
            this.page = page;
        }

        @Override
        public Maybe<String> findVariable(String name) {
            if (this.page.isRoot()) {
                return Maybe.noString;
            }
            WikiPage parentPage = this.page.getParent();
            if (parentPage instanceof WikitextPage) {
                return ((WikitextPage)((Object)parentPage)).getParsingPage().findVariable(name);
            }
            String value = parentPage.getVariable(name);
            return value != null ? new Maybe<String>(value) : Maybe.noString;
        }
    }

    public static class UserVariableSource
    implements VariableSource {
        private final VariableSource variableSource;

        public UserVariableSource(VariableSource variableSource) {
            this.variableSource = variableSource;
        }

        @Override
        public Maybe<String> findVariable(String name) {
            Maybe<String> result;
            if (this.variableSource instanceof UrlPathVariableSource && !(result = ((UrlPathVariableSource)this.variableSource).findUrlVariable(name)).isNothing()) {
                return result;
            }
            return Maybe.noString;
        }
    }
}

