/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.wiki.BaseWikiPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageFactory;
import fitnesse.wiki.fs.ExternalSuitePage;
import fitnesse.wiki.fs.FileSystem;
import fitnesse.wikitext.parser.VariableSource;
import java.io.File;

public class ExternalSuitePageFactory
implements WikiPageFactory<BaseWikiPage> {
    private final FileSystem fileSystem;

    public ExternalSuitePageFactory(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public WikiPage makePage(File path, String pageName, BaseWikiPage parent, VariableSource variableSource) {
        return new ExternalSuitePage(path, pageName, parent, this.fileSystem, variableSource);
    }

    @Override
    public boolean supports(File path) {
        return this.hasHtmlChild(path);
    }

    private boolean hasHtmlChild(File path) {
        if (path.getName().endsWith(".html")) {
            return true;
        }
        for (String child : this.fileSystem.list(path)) {
            if (!this.hasHtmlChild(new File(path, child))) continue;
            return true;
        }
        return false;
    }
}

