/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.userdetails.cache;

import java.io.Serializable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public class EhCacheBasedUserCache
implements UserCache,
InitializingBean {
    private static final Log logger = LogFactory.getLog(EhCacheBasedUserCache.class);
    private Ehcache cache;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"cache mandatory");
    }

    public Ehcache getCache() {
        return this.cache;
    }

    public UserDetails getUserFromCache(String username) {
        Element element = this.cache.get((Serializable)((Object)username));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache hit: " + (element != null) + "; username: " + username));
        }
        if (element == null) {
            return null;
        }
        return (UserDetails)element.getValue();
    }

    public void putUserInCache(UserDetails user) {
        Element element = new Element((Serializable)((Object)user.getUsername()), (Serializable)user);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache put: " + element.getKey()));
        }
        this.cache.put(element);
    }

    public void removeUserFromCache(UserDetails user) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache remove: " + user.getUsername()));
        }
        this.removeUserFromCache(user.getUsername());
    }

    public void removeUserFromCache(String username) {
        this.cache.remove((Serializable)((Object)username));
    }

    public void setCache(Ehcache cache) {
        this.cache = cache;
    }
}

